package ir.msob.jima.cloud.rsocket.commons.util;

import io.rsocket.DuplexConnection;
import io.rsocket.RSocket;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.net.SocketAddress;

public class RSocketUtil {
    private RSocketUtil() {
    }

    public static DuplexConnection getConnectionFromRequester(RSocketRequester requester) {
        RSocket rsocket = requester.rsocket();
        if (rsocket != null) {
            Field connectionField = ReflectionUtils.findField(rsocket.getClass(), "connection");
            if (connectionField != null) {
                connectionField.setAccessible(true);
                return (DuplexConnection) ReflectionUtils.getField(connectionField, rsocket);
            }
            throw new RuntimeException("ConnectionField is null");
        }
        throw new RuntimeException("RSocket is null");
    }

    public static SocketAddress getRemoteAddressFromRequester(RSocketRequester requester) {
        DuplexConnection connection = RSocketUtil.getConnectionFromRequester(requester);
        if (connection != null) {
            return connection.remoteAddress();
        } else {
            throw new RuntimeException("DuplexConnection is null");
        }
    }

    public static String getRemoteHostFromRequester(RSocketRequester requester) {
        if (requester == null) return null;
        SocketAddress socketAddress = RSocketUtil.getRemoteAddressFromRequester(requester);
        return socketAddress.toString().split(":")[0].replace("/", "");
    }

}
