/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.commons.model;

import ir.msob.jima.core.commons.model.dto.ModelType;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.springframework.boot.rsocket.server.RSocketServer;

public class ConnectionInfo
extends ModelType {
    private String uri;
    private String host = "localhost";
    private Integer port = 7002;
    private RSocketServer.Transport transport = RSocketServer.Transport.TCP;

    public String getServerUrl() {
        if (Strings.isBlank((String)this.getUri())) {
            if (Strings.isNotBlank((String)this.getHost()) && this.getTransport() != null && this.getPort() != null) {
                return String.format("%s://%s:%d", this.getTransportAsString(), this.getHost(), this.getPort());
            }
            throw new RuntimeException("Invalid rsocket server info : " + String.format("%s://%s:%d", this.getTransportAsString(), this.getHost(), this.getPort()));
        }
        return this.getUri();
    }

    public String getHost() {
        if (Strings.isBlank((String)this.host)) {
            return "localhost";
        }
        return this.host;
    }

    public Integer getPort() {
        if (this.port == null) {
            return 7002;
        }
        return this.port;
    }

    public RSocketServer.Transport getTransport() {
        if (this.transport == null) {
            return RSocketServer.Transport.TCP;
        }
        return this.transport;
    }

    public String getTransportAsString() {
        if (this.transport == RSocketServer.Transport.TCP) {
            return "tcp";
        }
        if (this.transport == RSocketServer.Transport.WEBSOCKET) {
            return "ws";
        }
        return "tcp";
    }

    @Generated
    public static ConnectionInfoBuilder builder() {
        return new ConnectionInfoBuilder();
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setTransport(RSocketServer.Transport transport) {
        this.transport = transport;
    }

    @Generated
    public ConnectionInfo(String uri, String host, Integer port, RSocketServer.Transport transport) {
        this.uri = uri;
        this.host = host;
        this.port = port;
        this.transport = transport;
    }

    @Generated
    public ConnectionInfo() {
    }

    @Generated
    public String toString() {
        return "ConnectionInfo(uri=" + this.getUri() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", transport=" + String.valueOf(this.getTransport()) + ")";
    }

    @Generated
    public static class ConnectionInfoBuilder {
        @Generated
        private String uri;
        @Generated
        private String host;
        @Generated
        private Integer port;
        @Generated
        private RSocketServer.Transport transport;

        @Generated
        ConnectionInfoBuilder() {
        }

        @Generated
        public ConnectionInfoBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Generated
        public ConnectionInfoBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public ConnectionInfoBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public ConnectionInfoBuilder transport(RSocketServer.Transport transport) {
            this.transport = transport;
            return this;
        }

        @Generated
        public ConnectionInfo build() {
            return new ConnectionInfo(this.uri, this.host, this.port, this.transport);
        }

        @Generated
        public String toString() {
            return "ConnectionInfo.ConnectionInfoBuilder(uri=" + this.uri + ", host=" + this.host + ", port=" + this.port + ", transport=" + String.valueOf(this.transport) + ")";
        }
    }
}

