/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.commons.util;

import io.rsocket.DuplexConnection;
import io.rsocket.RSocket;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.ReflectionUtils;

public class RSocketUtil {
    private RSocketUtil() {
    }

    public static DuplexConnection getConnectionFromRequester(RSocketRequester requester) {
        RSocket rsocket = requester.rsocket();
        if (rsocket != null) {
            Field connectionField = ReflectionUtils.findField((Class)rsocket.getClass(), (String)"connection");
            if (connectionField != null) {
                connectionField.setAccessible(true);
                return (DuplexConnection)ReflectionUtils.getField((Field)connectionField, (Object)rsocket);
            }
            throw new RuntimeException("ConnectionField is null");
        }
        throw new RuntimeException("RSocket is null");
    }

    public static SocketAddress getRemoteAddressFromRequester(RSocketRequester requester) {
        DuplexConnection connection = RSocketUtil.getConnectionFromRequester(requester);
        if (connection != null) {
            return connection.remoteAddress();
        }
        throw new RuntimeException("DuplexConnection is null");
    }

    public static String getRemoteHostFromRequester(RSocketRequester requester) {
        if (requester == null) {
            return null;
        }
        SocketAddress socketAddress = RSocketUtil.getRemoteAddressFromRequester(requester);
        return socketAddress.toString().split(":")[0].replace("/", "");
    }
}

