package ir.msob.jima.cloud.rsocket.commons.util;

import java.util.ArrayList;

public class RoundRobinList<E> extends ArrayList<E> {
    private final Object lockObject = new Object();
    private int index = 0;

    public E next() {
        synchronized (lockObject) {
            if (this.isEmpty())
                return null;
            return this.get(nextIndex());
        }
    }

    public E nextExcept(E except) {
        synchronized (lockObject) {
            if (this.isEmpty())
                return null;
            if (this.size() == 1 && this.get(0).equals(except)) {
                return null;
            }
            E result = this.get(nextIndex());
            if (result.equals(except)) {
                return this.get(nextIndex());
            }
            return result;
        }
    }

    private int nextIndex() {
        if (this.size() > this.index) {
            return index++;
        } else {
            this.index = 0;
            return 0;
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
