package ir.msob.jima.cloud.rsocket.gateway.server.controller;

import ir.msob.jima.cloud.rsocket.beans.ApplicationCacheService;
import ir.msob.jima.cloud.rsocket.beans.RequesterBuilder;
import ir.msob.jima.cloud.rsocket.commons.model.InstanceInfo;
import ir.msob.jima.cloud.rsocket.commons.model.RequestPayload;
import ir.msob.jima.cloud.rsocket.servicediscovery.client.controller.ApplicationController;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Controller;
import reactor.core.publisher.Mono;

import static ir.msob.jima.cloud.rsocket.commons.Constants.*;

@Controller
@MessageMapping(GATEWAY_SERVER_ROUTE)
@RequiredArgsConstructor
@Log4j2
public class ClientRequestController {

    private final ApplicationCacheService applicationCacheService;
    private final RequesterBuilder requesterBuilder;
    private final ApplicationController applicationController;


    @MessageMapping(CLIENT_REQUEST_RESPONSE_ROUTE)
    public Mono<Object> requestResponse(@Payload RequestPayload payload) {
        log.info("Received {} request: {}", CLIENT_REQUEST_RESPONSE_ROUTE, payload);
        InstanceInfo instanceInfo = getInstanceInfo(payload.getApplicationName());
        return instanceInfo.getRequester()
                .route(payload.getRoute())
                .data(payload.getData())
                .retrieveMono(Object.class);
    }

    @MessageMapping(CLIENT_FIRE_AND_FORGET_ROUTE)
    public Mono<Void> fireAndForget(@Payload RequestPayload payload) {
        log.info("Received {} request: {}", CLIENT_FIRE_AND_FORGET_ROUTE, payload);
        InstanceInfo instanceInfo = getInstanceInfo(payload.getApplicationName());
        return instanceInfo.getRequester()
                .route(payload.getRoute())
                .data(payload.getData())
                .send();
    }


    public InstanceInfo getInstanceInfo(String applicationName) {
        InstanceInfo instanceInfo = applicationCacheService.getInstanceInfo(applicationName);
        if (instanceInfo.getRequester() == null) {
            instanceInfo.setRequester(requesterBuilder.builder()
                    .connectionInfo(instanceInfo.getConnectionInfo())
                    .addHandler(applicationController)
                    .build());
        }
        return instanceInfo;
    }
}
