/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.gateway.server.controller;

import ir.msob.jima.cloud.rsocket.beans.ApplicationCacheService;
import ir.msob.jima.cloud.rsocket.beans.RequesterBuilder;
import ir.msob.jima.cloud.rsocket.commons.model.InstanceInfo;
import ir.msob.jima.cloud.rsocket.commons.model.RequestPayload;
import ir.msob.jima.cloud.rsocket.servicediscovery.client.controller.ApplicationController;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Controller;
import reactor.core.publisher.Mono;

@Controller
@MessageMapping(value={"gateway-server"})
public class ClientRequestController {
    @Generated
    private static final Logger log = LogManager.getLogger(ClientRequestController.class);
    private final ApplicationCacheService applicationCacheService;
    private final RequesterBuilder requesterBuilder;
    private final ApplicationController applicationController;

    @MessageMapping(value={"client.request-response"})
    public Mono<Object> requestResponse(@Payload RequestPayload payload) {
        log.info("Received {} request: {}", (Object)"client.request-response", (Object)payload);
        InstanceInfo instanceInfo = this.getInstanceInfo(payload.getApplicationName());
        return instanceInfo.getRequester().route(payload.getRoute(), new Object[0]).data(payload.getData()).retrieveMono(Object.class);
    }

    @MessageMapping(value={"client.fire-and-forget"})
    public Mono<Void> fireAndForget(@Payload RequestPayload payload) {
        log.info("Received {} request: {}", (Object)"client.fire-and-forget", (Object)payload);
        InstanceInfo instanceInfo = this.getInstanceInfo(payload.getApplicationName());
        return instanceInfo.getRequester().route(payload.getRoute(), new Object[0]).data(payload.getData()).send();
    }

    public InstanceInfo getInstanceInfo(String applicationName) {
        InstanceInfo instanceInfo = this.applicationCacheService.getInstanceInfo(applicationName);
        if (instanceInfo.getRequester() == null) {
            instanceInfo.setRequester(this.requesterBuilder.builder().connectionInfo(instanceInfo.getConnectionInfo()).addHandler((Object)this.applicationController).build());
        }
        return instanceInfo;
    }

    @Generated
    public ClientRequestController(ApplicationCacheService applicationCacheService, RequesterBuilder requesterBuilder, ApplicationController applicationController) {
        this.applicationCacheService = applicationCacheService;
        this.requesterBuilder = requesterBuilder;
        this.applicationController = applicationController;
    }
}

