package ir.msob.jima.cloud.rsocket.gateway.server;

import ir.msob.jima.cloud.rsocket.commons.model.ClientInfo;
import lombok.Getter;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class ClientCacheService {
    @Getter
    private final Map<String, ClientInfo> clients = new HashMap<>();
    private final Object lockObject = new Object();

    public ClientInfo getClientInfo(String clientId) {
        return clients.get(clientId);
    }

    public void add(ClientInfo clientInfo) {
        synchronized (lockObject) {
            clients.put(clientInfo.getClientId(), clientInfo);
        }
    }

    public void remove(ClientInfo clientInfo) {
        synchronized (lockObject) {
            clients.remove(clientInfo.getClientId());
        }
    }
}
