/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.gateway.server.controller;

import ir.msob.jima.cloud.rsocket.beans.ApplicationCacheService;
import ir.msob.jima.cloud.rsocket.beans.RequesterBuilder;
import ir.msob.jima.cloud.rsocket.commons.model.ClientInfo;
import ir.msob.jima.cloud.rsocket.commons.model.InstanceInfo;
import ir.msob.jima.cloud.rsocket.commons.model.RequestPayload;
import ir.msob.jima.cloud.rsocket.gateway.server.ClientCacheService;
import ir.msob.jima.cloud.rsocket.servicediscovery.client.properties.ServiceDiscoveryClientProperties;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Controller;
import reactor.core.publisher.Mono;

@Controller
@MessageMapping(value={"gateway-server"})
public class ApplicationRequestController {
    @Generated
    private static final Logger log = LogManager.getLogger(ApplicationRequestController.class);
    private final ClientCacheService clientCacheService;
    private final ServiceDiscoveryClientProperties serviceDiscoveryClientProperties;
    private final ApplicationCacheService applicationCacheService;
    private final RequesterBuilder requesterBuilder;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @MessageMapping(value={"application.request-response"})
    public Mono<Object> requestResponse(@Payload RequestPayload payload) {
        log.info("Received {} request: {}", (Object)"application.request-response", (Object)payload);
        ClientInfo clientInfo = this.clientCacheService.getClientInfo(payload.getClientId());
        if (clientInfo.getGatewayId().equals(this.serviceDiscoveryClientProperties.getInstanceId())) {
            return clientInfo.getRequester().route(payload.getRoute(), new Object[0]).data(payload.getData()).retrieveMono(Object.class);
        }
        InstanceInfo instanceInfo = this.applicationCacheService.getInstanceInfos(this.applicationName).stream().filter(ii -> Objects.equals(ii.getInstanceId(), clientInfo.getGatewayId())).findFirst().orElseThrow();
        if (instanceInfo.getRequester() == null) {
            instanceInfo.setRequester(this.requesterBuilder.builder().connectionInfo(instanceInfo.getConnectionInfo()).build());
        }
        return instanceInfo.getRequester().route("application.request-response", new Object[0]).data((Object)payload).retrieveMono(Object.class);
    }

    @MessageMapping(value={"application.fire-and-forget"})
    public Mono<Void> fireAndForget(@Payload RequestPayload payload) {
        log.info("Received {} request: {}", (Object)"application.fire-and-forget", (Object)payload);
        ClientInfo clientInfo = this.clientCacheService.getClientInfo(payload.getClientId());
        if (clientInfo.getGatewayId().equals(this.serviceDiscoveryClientProperties.getInstanceId())) {
            return clientInfo.getRequester().route(payload.getRoute(), new Object[0]).data(payload.getData()).send();
        }
        InstanceInfo instanceInfo = this.applicationCacheService.getInstanceInfos(this.applicationName).stream().filter(ii -> Objects.equals(ii.getInstanceId(), clientInfo.getGatewayId())).findFirst().orElseThrow();
        if (instanceInfo.getRequester() == null) {
            instanceInfo.setRequester(this.requesterBuilder.builder().connectionInfo(instanceInfo.getConnectionInfo()).build());
        }
        return instanceInfo.getRequester().route("application.fire-and-forget", new Object[0]).data((Object)payload).send();
    }

    @MessageMapping(value={"application.fire-and-forget-without-waiting"})
    public Mono<Void> fireAndForgetWithoutWaiting(@Payload RequestPayload payload) {
        log.info("Received {} request: {}", (Object)"application.fire-and-forget-without-waiting", (Object)payload);
        ClientInfo clientInfo = this.clientCacheService.getClientInfo(payload.getClientId());
        if (clientInfo.getGatewayId().equals(this.serviceDiscoveryClientProperties.getInstanceId())) {
            clientInfo.getRequester().route(payload.getRoute(), new Object[0]).data(payload.getData()).send().subscribe();
        } else {
            InstanceInfo instanceInfo = this.applicationCacheService.getInstanceInfos(this.applicationName).stream().filter(ii -> Objects.equals(ii.getInstanceId(), clientInfo.getGatewayId())).findFirst().orElseThrow();
            if (instanceInfo.getRequester() == null) {
                instanceInfo.setRequester(this.requesterBuilder.builder().connectionInfo(instanceInfo.getConnectionInfo()).build());
            }
            instanceInfo.getRequester().route("application.fire-and-forget-without-waiting", new Object[0]).data((Object)payload).send().subscribe();
        }
        return Mono.empty();
    }

    @Generated
    public ApplicationRequestController(ClientCacheService clientCacheService, ServiceDiscoveryClientProperties serviceDiscoveryClientProperties, ApplicationCacheService applicationCacheService, RequesterBuilder requesterBuilder) {
        this.clientCacheService = clientCacheService;
        this.serviceDiscoveryClientProperties = serviceDiscoveryClientProperties;
        this.applicationCacheService = applicationCacheService;
        this.requesterBuilder = requesterBuilder;
    }
}

