/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.gateway.server.client;

import ir.msob.jima.cloud.rsocket.beans.ApplicationCacheService;
import ir.msob.jima.cloud.rsocket.beans.RequesterBuilder;
import ir.msob.jima.cloud.rsocket.commons.model.ClientInfo;
import ir.msob.jima.cloud.rsocket.commons.model.ClientPayload;
import ir.msob.jima.cloud.rsocket.commons.model.InstanceInfo;
import ir.msob.jima.cloud.rsocket.servicediscovery.client.properties.ServiceDiscoveryClientProperties;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.stereotype.Service;

@Service
public class GatewayClient {
    @Generated
    private static final Logger log = LogManager.getLogger(GatewayClient.class);
    private final ApplicationCacheService applicationCacheService;
    private final ServiceDiscoveryClientProperties serviceDiscoveryClientProperties;
    private final RequesterBuilder requesterBuilder;
    @Value(value="${spring.application.name}")
    private String applicationName;

    public void registerClient(ClientInfo clientInfo) {
        this.applicationCacheService.getInstanceInfos(this.applicationName).stream().filter(instanceInfo -> !Objects.equals(this.serviceDiscoveryClientProperties.getInstanceId(), instanceInfo.getInstanceId())).map(this::prepareRequester).forEach(ii -> ii.getRequester().route("gateway-server.client.register", new Object[0]).data((Object)ClientPayload.builder().clientId(clientInfo.getClientId()).gatewayId(this.serviceDiscoveryClientProperties.getInstanceId()).build()).retrieveMono(ClientPayload.class).log().subscribe());
    }

    private InstanceInfo prepareRequester(InstanceInfo instanceInfo) {
        if (instanceInfo.getRequester() == null) {
            RSocketRequester requester = this.requesterBuilder.builder().connectionInfo(instanceInfo.getConnectionInfo()).build();
            instanceInfo.setRequester(requester);
        }
        return instanceInfo;
    }

    public void unregisterClient(ClientInfo clientInfo) {
        this.applicationCacheService.getInstanceInfos(this.applicationName).stream().filter(instanceInfo -> !Objects.equals(this.serviceDiscoveryClientProperties.getInstanceId(), instanceInfo.getInstanceId())).forEach(ii -> ii.getRequester().route("gateway-server.client.unregister", new Object[0]).data((Object)ClientPayload.builder().clientId(clientInfo.getClientId()).gatewayId(this.serviceDiscoveryClientProperties.getInstanceId()).build()).retrieveMono(ClientPayload.class).log().subscribe());
    }

    @Generated
    public GatewayClient(ApplicationCacheService applicationCacheService, ServiceDiscoveryClientProperties serviceDiscoveryClientProperties, RequesterBuilder requesterBuilder) {
        this.applicationCacheService = applicationCacheService;
        this.serviceDiscoveryClientProperties = serviceDiscoveryClientProperties;
        this.requesterBuilder = requesterBuilder;
    }
}

