/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.gateway.server.controller;

import ir.msob.jima.cloud.rsocket.commons.model.ClientInfo;
import ir.msob.jima.cloud.rsocket.commons.model.ClientPayload;
import ir.msob.jima.cloud.rsocket.gateway.server.ClientCacheService;
import ir.msob.jima.cloud.rsocket.gateway.server.client.GatewayClient;
import ir.msob.jima.cloud.rsocket.servicediscovery.client.properties.ServiceDiscoveryClientProperties;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.annotation.ConnectMapping;
import org.springframework.stereotype.Controller;

@Controller
@MessageMapping(value={"gateway-server"})
public class ClientController {
    @Generated
    private static final Logger log = LogManager.getLogger(ClientController.class);
    private final ClientCacheService clientCacheService;
    private final GatewayClient gatewayClient;
    private final ServiceDiscoveryClientProperties serviceDiscoveryClientProperties;

    @ConnectMapping(value={"client.setup"})
    public void connecting(RSocketRequester requester, @Payload ClientPayload payload) {
        log.info("{} ConnectMapping. {}", (Object)"client.connect", (Object)payload);
        if (requester.rsocket() == null) {
            throw new RuntimeException("Requester socket is null");
        }
        Objects.requireNonNull(requester.rsocket()).onClose().doFirst(() -> {
            log.info("Client connected. {}", (Object)payload);
            this.connect(requester, payload);
        }).doOnError(error -> {
            log.info("Client connection has an error. payload {}, error {}", (Object)payload, error);
            this.disconnect(payload);
        }).doFinally(consumer -> {
            log.info("Client disconnected. payload {}, consumer {}", (Object)payload, consumer);
            this.disconnect(payload);
        }).subscribe();
    }

    @MessageMapping(value={"client.register"})
    public void register(@Payload ClientPayload payload) {
        log.info("Received {} request: {}", (Object)"client.register", (Object)payload);
        ClientInfo clientInfo = ClientInfo.builder().clientId(payload.getClientId()).gatewayId(payload.getGatewayId()).build();
        this.clientCacheService.add(clientInfo);
    }

    @MessageMapping(value={"client.unregister"})
    public void unregister(@Payload ClientPayload payload) {
        log.info("Received {} request: {}", (Object)"client.unregister", (Object)payload);
        ClientInfo clientInfo = ClientInfo.builder().clientId(payload.getClientId()).gatewayId(payload.getGatewayId()).build();
        this.clientCacheService.remove(clientInfo);
    }

    private void connect(RSocketRequester requester, ClientPayload payload) {
        payload.setGatewayId(this.serviceDiscoveryClientProperties.getInstanceId());
        ClientInfo clientInfo = ClientInfo.builder().clientId(payload.getClientId()).gatewayId(payload.getGatewayId()).requester(requester).build();
        this.clientCacheService.add(clientInfo);
        this.gatewayClient.registerClient(clientInfo);
        this.returnPayload(requester, payload);
    }

    private void returnPayload(RSocketRequester requester, ClientPayload payload) {
        requester.route("client.setup", new Object[0]).data((Object)payload).send().subscribe();
    }

    private void disconnect(ClientPayload payload) {
        ClientInfo clientInfo = ClientInfo.builder().clientId(payload.getClientId()).gatewayId(this.serviceDiscoveryClientProperties.getInstanceId()).build();
        this.clientCacheService.remove(clientInfo);
        this.gatewayClient.unregisterClient(clientInfo);
    }

    @Generated
    public ClientController(ClientCacheService clientCacheService, GatewayClient gatewayClient, ServiceDiscoveryClientProperties serviceDiscoveryClientProperties) {
        this.clientCacheService = clientCacheService;
        this.gatewayClient = gatewayClient;
        this.serviceDiscoveryClientProperties = serviceDiscoveryClientProperties;
    }
}

