package ir.msob.jima.href.commons;

import java.util.Arrays;
import java.util.Collection;

public interface HrefModel {
    Collection<Link> getLinks();

    void setLinks(Collection<Link> links);

    default void add(Link link) {
        this.getLinks().add(link);
    }

    default void add(Iterable<Link> links) {
        links.forEach(this::add);
    }

    default void add(Link... links) {
        this.add(Arrays.asList(links));
    }
}
