package ir.msob.jima.href.commons;

import com.fasterxml.jackson.annotation.JsonInclude;
import ir.msob.jima.core.commons.model.BaseModel;
import lombok.*;

@Setter
@Getter
@ToString(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Link implements BaseModel {
    private String href;
    private String type;

    public static Link of(String href, String type) {
        return new Link(href, type);
    }
}
