/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.href.service;

import ir.msob.jima.core.beans.properties.JimaProperties;
import ir.msob.jima.core.commons.annotation.domain.DomainService;
import ir.msob.jima.core.commons.exception.badrequest.BadRequestException;
import ir.msob.jima.core.commons.exception.domainnotfound.DomainNotFoundException;
import ir.msob.jima.core.commons.model.criteria.BaseCriteria;
import ir.msob.jima.core.commons.model.dto.BaseDto;
import ir.msob.jima.core.commons.operation.BaseBeforeAfterOperation;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.href.commons.Href;
import ir.msob.jima.href.commons.HrefModel;
import ir.msob.jima.href.commons.Link;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class HrefBeforeAfterOperation
implements BaseBeforeAfterOperation {
    private final JimaProperties jimaProperties;

    public <ID extends Comparable<ID> & Serializable, USER extends BaseUser, DTO extends BaseDto<ID>, C extends BaseCriteria<ID>> void afterGet(Collection<ID> ids, Collection<DTO> dtos, C criteria, Optional<USER> user) throws DomainNotFoundException, BadRequestException {
        if (dtos.isEmpty()) {
            return;
        }
        AtomicReference dtoClass = new AtomicReference();
        dtos.stream().findFirst().ifPresent(dto -> dtoClass.set(dto.getClass()));
        Href href = (Href)Href.info.getAnnotation((Class)dtoClass.get());
        DomainService domainService = (DomainService)DomainService.info.getAnnotation((Class)dtoClass.get());
        if (href != null && domainService != null) {
            for (BaseDto dto2 : dtos) {
                if (!(dto2 instanceof HrefModel)) continue;
                HrefModel hrefModel = (HrefModel)dto2;
                hrefModel.add(this.prepareLinks(domainService, dto2));
            }
        }
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>> Iterable<Link> prepareLinks(DomainService domainService, DTO dto) {
        return List.of(this.prepareSelfLink(domainService, dto), this.preparePageLink(domainService), this.prepareCollectionLink(domainService));
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>> Link prepareSelfLink(DomainService domainService, DTO dto) {
        return Link.of((String)this.getUrl(domainService, "/" + dto.getDomainId().toString()), (String)"SELF");
    }

    private Link preparePageLink(DomainService domainService) {
        return Link.of((String)this.getUrl(domainService, ""), (String)"PAGE");
    }

    private Link prepareCollectionLink(DomainService domainService) {
        return Link.of((String)this.getUrl(domainService, "/get-many"), (String)"COLLECTION");
    }

    private String getUrl(DomainService domainService, String suffix) {
        return String.format("%s/%s/%s/%s/%s%s", this.jimaProperties.getHref().getBaseUrl(), domainService.serviceName(), "api", domainService.version(), domainService.domainName(), suffix);
    }

    @Generated
    public HrefBeforeAfterOperation(JimaProperties jimaProperties) {
        this.jimaProperties = jimaProperties;
    }
}

