/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.lock.ral.mongo.beans;

import ir.msob.jima.core.beans.properties.JimaProperties;
import ir.msob.jima.core.commons.logger.Logger;
import ir.msob.jima.core.commons.logger.LoggerFactory;
import ir.msob.jima.lock.ral.mongo.beans.LockLog;
import jakarta.annotation.PostConstruct;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;

@Configuration
public class LockLogConfiguration {
    private static final Logger log = LoggerFactory.getLog(LockLogConfiguration.class);
    private final ReactiveMongoTemplate reactiveMongoTemplate;
    private final JimaProperties jimaProperties;

    @PostConstruct
    public void createIndexes() {
        this.reactiveMongoTemplate.indexOps(LockLog.class).ensureIndex((IndexDefinition)new Index().on(LockLog.FN.ts.name(), Sort.Direction.ASC).expire(this.jimaProperties.getLock().getExpiration())).subscribe(s -> log.info("Result of creating index of {}.{} is {}", new Object[]{"LockLog", LockLog.FN.ts, s}));
    }

    public LockLogConfiguration(ReactiveMongoTemplate reactiveMongoTemplate, JimaProperties jimaProperties) {
        this.reactiveMongoTemplate = reactiveMongoTemplate;
        this.jimaProperties = jimaProperties;
    }
}

