/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.lock.service;

import ir.msob.jima.core.beans.spel.SpelRepository;
import ir.msob.jima.core.commons.annotation.Param;
import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.exception.runtime.CommonRuntimeException;
import ir.msob.jima.core.commons.logger.Logger;
import ir.msob.jima.core.commons.logger.LoggerFactory;
import ir.msob.jima.core.commons.util.BeanUtil;
import ir.msob.jima.lock.commons.BaseLockService;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LockAspect {
    private static final Logger log = LoggerFactory.getLog(LockAspect.class);
    private final SpelRepository spelRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodStats
    @Around(value="@annotation(ir.msob.jima.lock.commons.Lock)")
    public <K extends Serializable> Object processWithLock(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Object[] args = joinPoint.getArgs();
        Map<String, Object> methodParams = this.getParametersWithAnnotation(methodSignature, args);
        ir.msob.jima.lock.commons.Lock lockAnnotation = methodSignature.getMethod().getAnnotation(ir.msob.jima.lock.commons.Lock.class);
        Class locksServiceClass = lockAnnotation.lockService();
        BaseLockService locksService = (BaseLockService)BeanUtil.getBean((Class)locksServiceClass);
        String keyExpression = lockAnnotation.value();
        ArrayList<Serializable> keys = new ArrayList<Serializable>();
        Object keysObject = this.spelRepository.execute(keyExpression, methodParams, Object.class);
        if (keysObject instanceof Collection) {
            Collection keyCollection = (Collection)keysObject;
            keys.addAll(keyCollection.stream().map(o -> (Serializable)o).toList());
        } else {
            keys.add((Serializable)keysObject);
        }
        log.info("Attempting to acquire lock with keys: {}", new Object[]{keys});
        Lock lock = locksService.getLock(keys);
        lock.lock();
        try {
            log.debug("Lock acquired for keys: {}", new Object[]{keys});
            object = joinPoint.proceed();
            lock.unlock();
        }
        catch (Throwable throwable) {
            lock.unlock();
            log.debug("Lock released for keys: {}", new Object[]{keys});
            throw throwable;
        }
        log.debug("Lock released for keys: {}", new Object[]{keys});
        return object;
    }

    private Map<String, Object> getParametersWithAnnotation(MethodSignature methodSignature, Object[] args) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        if (methodSignature.getMethod().getParameterCount() != 0) {
            Annotation[][] parameterAnnotations = methodSignature.getMethod().getParameterAnnotations();
            block0: for (int i = 0; i < methodSignature.getMethod().getParameterCount(); ++i) {
                for (Annotation annotation : parameterAnnotations[i]) {
                    if (!annotation.annotationType().equals(Param.class)) continue;
                    Param paramAnnotation = (Param)annotation;
                    parameterMap.put(paramAnnotation.value(), args[i]);
                    continue block0;
                }
            }
        }
        if (parameterMap.isEmpty()) {
            throw new CommonRuntimeException("No parameters with the specified annotation found.", new Object[0]);
        }
        return parameterMap;
    }

    public LockAspect(SpelRepository spelRepository) {
        this.spelRepository = spelRepository;
    }
}

