/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.api.restful.service.rest.process;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.exception.badrequest.BadRequestResponse;
import ir.msob.jima.core.commons.model.scope.Scope;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.process.api.restful.service.rest.process.ParentProcessRestController;
import ir.msob.jima.process.commons.dto.ProcessDto;
import ir.msob.jima.process.commons.repository.BaseProcessRepository;
import ir.msob.jima.process.service.BaseProcessService;
import java.io.Serializable;
import java.security.Principal;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface BaseStartProcessRestController<ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, PR extends BaseProcessRepository, S extends BaseProcessService<ID, USER, PR>>
extends ParentProcessRestController<ID, USER, PR, S> {
    public static final Logger log = LoggerFactory.getLogger(BaseStartProcessRestController.class);

    @PostMapping(value={"start"})
    @ApiResponses(value={@ApiResponse(code=200, message="Return a domain or null"), @ApiResponse(code=400, message="If the validation operation is incorrect throws BadRequestException otherwise nothing", response=BadRequestResponse.class)})
    @Scope(value="start")
    @MethodStats
    default public ResponseEntity<Mono<ProcessDto>> start(@RequestBody ProcessDto dto, ServerWebExchange serverWebExchange, Principal principal) throws JsonProcessingException {
        log.debug("REST request to start process, dto {}", (Object)dto);
        Optional user = this.getUser(serverWebExchange, principal);
        return this.startResponse((Mono<ProcessDto>)this.getService().start(dto, user), user);
    }

    default public ResponseEntity<Mono<ProcessDto>> startResponse(Mono<ProcessDto> result, Optional<USER> user) {
        return ResponseEntity.ok(result);
    }
}

