/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.api.restful.service.rest.deployment;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.exception.badrequest.BadRequestResponse;
import ir.msob.jima.core.commons.model.scope.Scope;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.process.api.restful.service.rest.deployment.ParentDeploymentRestController;
import ir.msob.jima.process.commons.criteria.DeploymentCriteria;
import ir.msob.jima.process.commons.repository.BaseDeploymentRepository;
import ir.msob.jima.process.service.BaseDeploymentService;
import java.io.Serializable;
import java.security.Principal;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface BaseDeleteDeploymentRestController<ID extends Comparable<ID> & Serializable, USER extends BaseUser, DR extends BaseDeploymentRepository, S extends BaseDeploymentService<USER, DR>>
extends ParentDeploymentRestController<ID, USER, DR, S> {
    public static final Logger log = LoggerFactory.getLogger(BaseDeleteDeploymentRestController.class);

    @DeleteMapping(value={"delete"})
    @ApiResponses(value={@ApiResponse(code=200, message="Return a domain or null"), @ApiResponse(code=400, message="If the validation operation is incorrect throws BadRequestException otherwise nothing", response=BadRequestResponse.class)})
    @Scope(value="delete")
    @MethodStats
    default public ResponseEntity<Mono<Boolean>> delete(DeploymentCriteria criteria, ServerWebExchange serverWebExchange, Principal principal) throws JsonProcessingException {
        log.debug("REST request to delete deployment, criteria {}", (Object)criteria);
        Optional user = this.getUser(serverWebExchange, principal);
        return this.deleteResponse((Mono<Boolean>)this.getService().delete(criteria, user), user);
    }

    default public ResponseEntity<Mono<Boolean>> deleteResponse(Mono<Boolean> result, Optional<USER> user) {
        return ResponseEntity.ok(result);
    }
}

