/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.api.restful.service.rest.task;

import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.exception.badrequest.BadRequestResponse;
import ir.msob.jima.core.commons.model.scope.Scope;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.process.api.restful.service.rest.task.ParentTaskRestController;
import ir.msob.jima.process.commons.criteria.TaskCriteria;
import ir.msob.jima.process.commons.dto.TaskDto;
import ir.msob.jima.process.commons.repository.BaseTaskRepository;
import ir.msob.jima.process.service.BaseTaskService;
import java.io.Serializable;
import java.security.Principal;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import reactor.core.publisher.Mono;

public interface BaseCompleteTaskRestController<ID extends Comparable<ID> & Serializable, USER extends BaseUser, TR extends BaseTaskRepository, S extends BaseTaskService<USER, TR>>
extends ParentTaskRestController<ID, USER, TR, S> {
    public static final Logger log = LoggerFactory.getLogger(BaseCompleteTaskRestController.class);

    @PostMapping(value={"complete"})
    @ApiResponses(value={@ApiResponse(code=200, message="Return a domain or null"), @ApiResponse(code=400, message="If the validation operation is incorrect throws BadRequestException otherwise nothing", response=BadRequestResponse.class)})
    @Scope(value="complete")
    @MethodStats
    default public ResponseEntity<Mono<TaskDto>> complete(TaskCriteria criteria, Principal principal) {
        log.debug("REST request to complete task, criteria {}", (Object)criteria);
        Optional user = this.getUser(principal);
        return this.completeResponse((Mono<TaskDto>)this.getService().complete(criteria, user), user);
    }

    default public ResponseEntity<Mono<TaskDto>> completeResponse(Mono<TaskDto> result, Optional<USER> user) {
        return ResponseEntity.ok(result);
    }
}

