/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.ral.activiti.beans;

import ir.msob.jima.process.commons.criteria.DeploymentCriteria;
import ir.msob.jima.process.commons.dto.DeploymentDto;
import ir.msob.jima.process.commons.repository.BaseDeploymentRepository;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentQuery;
import org.apache.logging.log4j.util.Strings;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Mono;

@Repository
public class DeploymentRepository
implements BaseDeploymentRepository {
    private final RepositoryService repositoryService;

    public Mono<DeploymentDto> save(DeploymentDto dto, InputStream inputStream) {
        Deployment deployment = this.repositoryService.createDeployment().key(dto.getKey()).category(dto.getCategory()).name(dto.getName()).tenantId(dto.getTenantId()).addInputStream(dto.getName() + ".bpmn20.xml", inputStream).deploy();
        this.prepareDeploymentDto(dto, deployment);
        return Mono.just((Object)dto);
    }

    public Mono<Page<DeploymentDto>> getPage(DeploymentCriteria criteria, Pageable pageable) {
        long count = this.prepareDeploymentQuery(criteria).count();
        if (count < 1L) {
            return Mono.just((Object)new PageImpl(new ArrayList(), pageable, 0L));
        }
        List deployments = this.prepareDeploymentQuery(criteria).listPage(pageable.getPageNumber(), pageable.getPageSize());
        return Mono.just((Object)new PageImpl(this.prepareDeploymentDto(deployments), pageable, count));
    }

    public Mono<DeploymentDto> getOne(DeploymentCriteria criteria) {
        Deployment deployment = (Deployment)this.prepareDeploymentQuery(criteria).latest().singleResult();
        return Mono.just((Object)this.prepareDeploymentDto(deployment));
    }

    public Mono<Long> count(DeploymentCriteria criteria) {
        return Mono.just((Object)this.prepareDeploymentQuery(criteria).latest().count());
    }

    public Mono<DeploymentDto> delete(DeploymentCriteria criteria) {
        Deployment deployment = (Deployment)this.prepareDeploymentQuery(criteria).latest().singleResult();
        this.repositoryService.deleteDeployment(criteria.getId(), true);
        return Mono.just((Object)this.prepareDeploymentDto(deployment));
    }

    private DeploymentQuery prepareDeploymentQuery(DeploymentCriteria criteria) {
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        if (Strings.isNotBlank((String)criteria.getId())) {
            deploymentQuery.deploymentId(criteria.getId());
        }
        if (Strings.isNotBlank((String)criteria.getName())) {
            deploymentQuery.deploymentName(criteria.getName());
        }
        if (Strings.isNotBlank((String)criteria.getCategory())) {
            deploymentQuery.deploymentCategory(criteria.getCategory());
        }
        if (Strings.isNotBlank((String)criteria.getKey())) {
            deploymentQuery.deploymentKey(criteria.getKey());
        }
        if (Strings.isNotBlank((String)criteria.getTenantId())) {
            deploymentQuery.deploymentTenantId(criteria.getTenantId());
        }
        return deploymentQuery;
    }

    private List<DeploymentDto> prepareDeploymentDto(Collection<Deployment> deployments) {
        return deployments.stream().map(deployment -> this.prepareDeploymentDto((Deployment)deployment)).collect(Collectors.toList());
    }

    private DeploymentDto prepareDeploymentDto(Deployment deployment) {
        DeploymentDto dto = new DeploymentDto();
        this.prepareDeploymentDto(dto, deployment);
        return dto;
    }

    private void prepareDeploymentDto(DeploymentDto dto, Deployment deployment) {
        dto.setId(deployment.getId());
        dto.setName(deployment.getName());
        dto.setDate(deployment.getDeploymentTime().toInstant());
        dto.setCategory(deployment.getCategory());
        dto.setKey(deployment.getCategory());
        dto.setTenantId(deployment.getTenantId());
        dto.setVersion(deployment.getVersion());
        dto.setProjectReleaseVersion(deployment.getProjectReleaseVersion());
    }

    public DeploymentRepository(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

