/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.ral.activiti.beans;

import ir.msob.jima.core.commons.exception.badrequest.BadRequestException;
import ir.msob.jima.process.commons.criteria.ProcessCriteria;
import ir.msob.jima.process.commons.dto.ProcessDto;
import ir.msob.jima.process.commons.repository.BaseProcessRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.apache.logging.log4j.util.Strings;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Mono;

@Repository
public class ProcessRepository
implements BaseProcessRepository {
    private final RuntimeService runtimeService;

    public Mono<ProcessDto> save(ProcessDto dto) {
        ProcessInstance processInstance = this.runtimeService.createProcessInstanceBuilder().name(dto.getName()).processDefinitionId(dto.getId()).processDefinitionKey(dto.getKey()).businessKey(dto.getBusinessKey()).tenantId(dto.getTenantId()).variables(dto.getVariables()).transientVariables(dto.getTransientVariables()).messageName(dto.getMessageName()).start();
        return Mono.just((Object)this.prepareProcessDto(processInstance));
    }

    public Mono<ProcessDto> start(ProcessDto dto) {
        ProcessInstance processInstance = null;
        if (Strings.isNotBlank((String)dto.getId())) {
            processInstance = this.runtimeService.startProcessInstanceById(dto.getId(), dto.getVariables());
        } else if (Strings.isNotBlank((String)dto.getKey())) {
            processInstance = this.runtimeService.startProcessInstanceByKey(dto.getKey(), dto.getVariables());
        } else {
            BadRequestException.init((String)"Cannot fount any deployment id or key {}", (Object[])new Object[]{dto});
        }
        return Mono.just((Object)this.prepareProcessDto(processInstance));
    }

    public Mono<Boolean> delete(ProcessCriteria criteria) {
        this.runtimeService.deleteProcessInstance(criteria.getId(), null);
        return Mono.just((Object)true);
    }

    public Mono<Boolean> suspend(ProcessCriteria criteria) {
        this.runtimeService.suspendProcessInstanceById(criteria.getId());
        return Mono.just((Object)true);
    }

    public Mono<Boolean> resume(ProcessCriteria criteria) {
        this.runtimeService.activateProcessInstanceById(criteria.getId());
        return Mono.just((Object)true);
    }

    public Mono<ProcessDto> getOne(ProcessCriteria criteria) {
        ProcessInstanceQuery processInstanceQuery = this.prepareProcessInstanceQuery(criteria);
        return Mono.just((Object)this.prepareProcessDto((ProcessInstance)processInstanceQuery.singleResult()));
    }

    public Mono<Long> count(ProcessCriteria criteria) {
        ProcessInstanceQuery processInstanceQuery = this.prepareProcessInstanceQuery(criteria);
        return Mono.just((Object)processInstanceQuery.count());
    }

    public Mono<Page<ProcessDto>> getPage(ProcessCriteria criteria, Pageable pageable) {
        long count = this.prepareProcessInstanceQuery(criteria).count();
        if (count < 1L) {
            return Mono.just((Object)new PageImpl(new ArrayList(), pageable, 0L));
        }
        List processInstances = this.prepareProcessInstanceQuery(criteria).listPage(pageable.getPageNumber(), pageable.getPageSize());
        return Mono.just((Object)new PageImpl(this.prepareProcessDto(processInstances), pageable, count));
    }

    private ProcessInstanceQuery prepareProcessInstanceQuery(ProcessCriteria criteria) {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        if (Strings.isNotBlank((String)criteria.getId())) {
            processInstanceQuery.processInstanceId(criteria.getId());
        }
        if (criteria.isSuspended()) {
            processInstanceQuery.suspended();
        }
        if (Strings.isNotBlank((String)criteria.getName())) {
            processInstanceQuery.processInstanceName(criteria.getName());
        }
        if (Strings.isNotBlank((String)criteria.getKey())) {
            processInstanceQuery.processDefinitionKey(criteria.getKey());
        }
        if (criteria.getVersion() != null) {
            processInstanceQuery.processDefinitionVersion(criteria.getVersion());
        }
        if (Strings.isNotBlank((String)criteria.getDeploymentId())) {
            processInstanceQuery.deploymentId(criteria.getDeploymentId());
        }
        if (Strings.isNotBlank((String)criteria.getBusinessKey())) {
            processInstanceQuery.processInstanceBusinessKey(criteria.getBusinessKey());
        }
        if (Strings.isNotBlank((String)criteria.getTenantId())) {
            processInstanceQuery.processInstanceTenantId(criteria.getTenantId());
        }
        if (Strings.isNotBlank((String)criteria.getStartUserId())) {
            processInstanceQuery.involvedUser(criteria.getStartUserId());
        }
        return processInstanceQuery;
    }

    private List<ProcessDto> prepareProcessDto(Collection<ProcessInstance> processInstances) {
        return processInstances.stream().map(this::prepareProcessDto).toList();
    }

    private ProcessDto prepareProcessDto(ProcessInstance processInstance) {
        ProcessDto processDto = new ProcessDto();
        processDto.setId(processInstance.getProcessDefinitionId());
        processDto.setName(processInstance.getProcessDefinitionName());
        processDto.setDescription(processInstance.getDescription());
        processDto.setKey(processInstance.getProcessDefinitionKey());
        processDto.setVersion(processInstance.getProcessDefinitionVersion());
        processDto.setDeploymentId(processInstance.getDeploymentId());
        processDto.setBusinessKey(processInstance.getBusinessKey());
        processDto.setSuspended(processInstance.isSuspended());
        processDto.setVariables(processInstance.getProcessVariables());
        processDto.setTenantId(processInstance.getTenantId());
        processDto.setLocalizedName(processInstance.getLocalizedName());
        processDto.setLocalizedDescription(processInstance.getLocalizedDescription());
        processDto.setStartDate(processInstance.getStartTime().toInstant());
        processDto.setStartUserId(processInstance.getStartUserId());
        processDto.setAppVersion(processInstance.getAppVersion());
        return processDto;
    }

    public ProcessRepository(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }
}

