/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.ral.activiti.beans;

import ir.msob.jima.process.commons.criteria.TaskCriteria;
import ir.msob.jima.process.commons.dto.TaskDto;
import ir.msob.jima.process.commons.repository.BaseTaskRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.logging.log4j.util.Strings;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Mono;

@Repository
public class TaskRepository
implements BaseTaskRepository {
    private final TaskService taskService;

    public Mono<TaskDto> save(TaskDto dto) {
        Task task = this.taskService.saveTask(this.prepareTask(dto));
        return Mono.just((Object)this.prepareTaskDto(task));
    }

    public Mono<TaskDto> complete(TaskCriteria criteria) {
        return this.getOne(criteria).doOnSuccess(task -> this.taskService.complete(criteria.getId(), criteria.getVariables()));
    }

    public Mono<Boolean> delete(TaskCriteria criteria) {
        this.taskService.deleteTask(criteria.getId(), true);
        return Mono.just((Object)true);
    }

    public Mono<TaskDto> getOne(TaskCriteria criteria) {
        TaskQuery taskQuery = this.prepareTaskQuery(criteria);
        return Mono.just((Object)this.prepareTaskDto((Task)taskQuery.singleResult()));
    }

    public Mono<Long> count(TaskCriteria criteria) {
        return Mono.just((Object)this.prepareTaskQuery(criteria).count());
    }

    public Mono<Page<TaskDto>> getPage(TaskCriteria criteria, Pageable pageable) {
        long count = this.prepareTaskQuery(criteria).count();
        if (count < 1L) {
            return Mono.just((Object)new PageImpl(new ArrayList(), pageable, 0L));
        }
        List tasks = this.prepareTaskQuery(criteria).listPage(pageable.getPageNumber(), pageable.getPageSize());
        return Mono.just((Object)new PageImpl(this.prepareTaskDto(tasks), pageable, count));
    }

    private TaskQuery prepareTaskQuery(TaskCriteria criteria) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (Strings.isNotBlank((String)criteria.getId())) {
            taskQuery.taskId(criteria.getId());
        }
        if (Strings.isNotBlank((String)criteria.getName())) {
            taskQuery.taskName(criteria.getName());
        }
        if (Strings.isNotBlank((String)criteria.getDescription())) {
            taskQuery.taskDescription(criteria.getDescription());
        }
        if (criteria.getPriority() != null) {
            taskQuery.taskPriority(criteria.getPriority());
        }
        if (Strings.isNotBlank((String)criteria.getOwner())) {
            taskQuery.taskOwner(criteria.getOwner());
        }
        if (Strings.isNotBlank((String)criteria.getAssignee())) {
            taskQuery.taskAssignee(criteria.getAssignee());
        }
        if (criteria.getDueDate() != null) {
            taskQuery.taskDueDate(Date.from(criteria.getDueDate()));
        }
        if (Strings.isNotBlank((String)criteria.getCategory())) {
            taskQuery.taskCategory(criteria.getCategory());
        }
        if (Strings.isNotBlank((String)criteria.getParentTaskId())) {
            taskQuery.taskParentTaskId(criteria.getParentTaskId());
        }
        if (Strings.isNotBlank((String)criteria.getTenantId())) {
            taskQuery.taskTenantId(criteria.getTenantId());
        }
        if (criteria.isSuspended()) {
            taskQuery.suspended();
        }
        return taskQuery;
    }

    private Task prepareTask(TaskDto dto) {
        Task task = this.taskService.newTask();
        task.setName(dto.getName());
        task.setLocalizedName(dto.getLocalizedName());
        task.setDescription(dto.getDescription());
        task.setLocalizedDescription(dto.getLocalizedDescription());
        task.setPriority(dto.getPriority());
        task.setOwner(dto.getOwner());
        task.setAssignee(dto.getAssignee());
        task.setDueDate(Date.from(dto.getDueDate()));
        task.setCategory(dto.getCategory());
        task.setParentTaskId(dto.getParentTaskId());
        task.setTenantId(dto.getTenantId());
        task.setFormKey(dto.getFormKey());
        task.setAppVersion(dto.getAppVersion());
        return task;
    }

    private List<TaskDto> prepareTaskDto(Collection<Task> tasks) {
        return tasks.stream().map(this::prepareTaskDto).toList();
    }

    private TaskDto prepareTaskDto(Task task) {
        TaskDto taskDto = new TaskDto();
        taskDto.setId(task.getId());
        taskDto.setName(task.getName());
        taskDto.setLocalizedName(taskDto.getLocalizedName());
        taskDto.setDescription(task.getDescription());
        taskDto.setPriority(task.getPriority());
        taskDto.setOwner(task.getOwner());
        taskDto.setAssignee(task.getAssignee());
        taskDto.setDelegationState(this.prepareDelegationState(task));
        if (task.getDueDate() != null) {
            taskDto.setDueDate(task.getDueDate().toInstant());
        }
        taskDto.setCategory(task.getCategory());
        taskDto.setParentTaskId(task.getParentTaskId());
        taskDto.setTenantId(task.getTenantId());
        taskDto.setFormKey(task.getFormKey());
        taskDto.setAppVersion(task.getAppVersion());
        taskDto.setSuspended(task.isSuspended());
        return taskDto;
    }

    private TaskDto.DelegationState prepareDelegationState(Task task) {
        if (task.getDelegationState() == DelegationState.PENDING) {
            return TaskDto.DelegationState.PENDING;
        }
        if (task.getDelegationState() == DelegationState.RESOLVED) {
            return TaskDto.DelegationState.RESOLVED;
        }
        return null;
    }

    public TaskRepository(TaskService taskService) {
        this.taskService = taskService;
    }
}

