/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.service;

import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.file.BaseFileClient;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.process.commons.criteria.DeploymentCriteria;
import ir.msob.jima.process.commons.dto.DeploymentDto;
import ir.msob.jima.process.commons.repository.BaseDeploymentRepository;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import reactor.core.publisher.Mono;

public interface BaseDeploymentService<ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, DR extends BaseDeploymentRepository> {
    public BaseFileClient getFileClient();

    public DR getDeploymentRepository();

    @MethodStats
    default public Mono<DeploymentDto> save(DeploymentDto dto, Optional<USER> user) {
        return this.getFileClient().get(dto.getFilePath(), user).flatMap(inputStream -> this.getDeploymentRepository().save(dto, inputStream));
    }

    @MethodStats
    default public Mono<Page<DeploymentDto>> getPage(DeploymentCriteria criteria, Pageable pageable, Optional<USER> user) {
        return this.getDeploymentRepository().getPage(criteria, pageable);
    }

    @MethodStats
    default public Mono<DeploymentDto> getOne(DeploymentCriteria criteria, Optional<USER> user) {
        return this.getDeploymentRepository().getOne(criteria);
    }

    @MethodStats
    default public Mono<Long> count(DeploymentCriteria criteria, Optional<USER> user) {
        return this.getDeploymentRepository().count(criteria);
    }

    @MethodStats
    default public Mono<Boolean> delete(DeploymentCriteria criteria, Optional<USER> user) {
        return this.getDeploymentRepository().getOne(criteria).flatMap(deploymentDto -> this.getFileClient().delete(deploymentDto.getFilePath(), user)).then(this.getDeploymentRepository().delete(criteria)).then(Mono.just((Object)true));
    }
}

