/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.service;

import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.process.commons.criteria.TaskCriteria;
import ir.msob.jima.process.commons.dto.TaskDto;
import ir.msob.jima.process.commons.repository.BaseTaskRepository;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import reactor.core.publisher.Mono;

public interface BaseTaskService<ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, TR extends BaseTaskRepository> {
    public TR getTaskRepository();

    @MethodStats
    default public Mono<TaskDto> save(TaskDto dto, Optional<USER> user) {
        return this.getTaskRepository().save(dto);
    }

    @MethodStats
    default public Mono<TaskDto> complete(TaskCriteria criteria, Optional<USER> user) {
        return this.getTaskRepository().complete(criteria);
    }

    @MethodStats
    default public Mono<Boolean> delete(TaskCriteria criteria, Optional<USER> user) {
        return this.getTaskRepository().delete(criteria);
    }

    @MethodStats
    default public Mono<TaskDto> getOne(TaskCriteria criteria, Optional<USER> user) {
        return this.getTaskRepository().getOne(criteria);
    }

    @MethodStats
    default public Mono<Long> count(TaskCriteria criteria, Optional<USER> user) {
        return this.getTaskRepository().count(criteria);
    }

    @MethodStats
    default public Mono<Page<TaskDto>> getPage(TaskCriteria criteria, Pageable pageable, Optional<USER> user) {
        return this.getTaskRepository().getPage(criteria, pageable);
    }
}

