/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.process.service;

import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.process.commons.criteria.ProcessCriteria;
import ir.msob.jima.process.commons.dto.ProcessDto;
import ir.msob.jima.process.commons.repository.BaseProcessRepository;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import reactor.core.publisher.Mono;

public interface BaseProcessService<USER extends BaseUser, PR extends BaseProcessRepository> {
    public PR getProcessRepository();

    @MethodStats
    default public Mono<ProcessDto> save(ProcessDto dto, Optional<USER> user) {
        return this.getProcessRepository().save(dto);
    }

    @MethodStats
    default public Mono<ProcessDto> start(ProcessDto dto, Optional<USER> user) {
        return this.getProcessRepository().start(dto);
    }

    @MethodStats
    default public Mono<Boolean> delete(ProcessCriteria criteria, Optional<USER> user) {
        return this.getProcessRepository().delete(criteria);
    }

    @MethodStats
    default public Mono<Boolean> suspend(ProcessCriteria criteria, Optional<USER> user) {
        return this.getProcessRepository().suspend(criteria);
    }

    @MethodStats
    default public Mono<Boolean> resume(ProcessCriteria criteria, Optional<USER> user) {
        return this.getProcessRepository().resume(criteria);
    }

    @MethodStats
    default public Mono<ProcessDto> getOne(ProcessCriteria criteria, Optional<USER> user) {
        return this.getProcessRepository().getOne(criteria);
    }

    @MethodStats
    default public Mono<Long> count(ProcessCriteria criteria, Optional<USER> user) {
        return this.getProcessRepository().count(criteria);
    }

    @MethodStats
    default public Mono<Page<ProcessDto>> getPage(ProcessCriteria criteria, Pageable pageable, Optional<USER> user) {
        return this.getProcessRepository().getPage(criteria, pageable);
    }
}

