package ir.msob.jima.search.api.kafka.client;

import ir.msob.jima.core.beans.properties.JimaProperties;
import ir.msob.jima.core.commons.client.BaseAsyncClient;
import ir.msob.jima.search.client.BaseSearchClient;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SearchKafkaClient implements BaseSearchClient {

    @Autowired
    BaseAsyncClient asyncClient;
    @Autowired
    ModelMapper modelMapper;
    @Autowired
    JimaProperties jimaProperties;

    @Override
    public BaseAsyncClient getAsyncClient() {
        return asyncClient;
    }

    @Override
    public ModelMapper getModelMapper() {
        return modelMapper;
    }

    @Override
    public JimaProperties getJimaProperties() {
        return jimaProperties;
    }
}
