package ir.msob.jima.search.api.kafka.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import ir.msob.jima.core.commons.model.channel.ChannelMessage;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.search.commons.model.SearchMessage;
import ir.msob.jima.search.service.BaseSearchReceiver;
import ir.msob.jima.search.service.BaseSearchService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;

import java.io.IOException;
import java.util.Optional;

@Log4j2
public abstract class BaseKafkaSearchListener<USER extends BaseUser> implements BaseSearchReceiver<USER> {

    @Autowired
    private BaseSearchService<USER> service;
    @Autowired
    private ObjectMapper objectMapper;

    @KafkaListener(topics = "${jima.search.channel}", groupId = "${spring.kafka.consumer.group-id}")
    public void listener(String message) throws IOException {
        log.debug("Search listener, message {}", message);
        ChannelMessage<USER, SearchMessage> channelMessage = objectMapper.readValue(message, getMessageReferenceType());
        receive(channelMessage, Optional.ofNullable(channelMessage.getUser()));
    }

    @Override
    public BaseSearchService<USER> getSearchService() {
        return service;
    }

    public TypeReference<ChannelMessage<USER, SearchMessage>> getMessageReferenceType() {
        return new TypeReference<ChannelMessage<USER, SearchMessage>>() {
        };
    }


}
