/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.search.api.kafka.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import ir.msob.jima.core.commons.model.channel.ChannelMessage;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.search.commons.model.SearchMessage;
import ir.msob.jima.search.service.BaseSearchReceiver;
import ir.msob.jima.search.service.BaseSearchService;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;

public abstract class BaseKafkaSearchListener<USER extends BaseUser>
implements BaseSearchReceiver<USER> {
    private static final Logger log = LogManager.getLogger(BaseKafkaSearchListener.class);
    @Autowired
    private BaseSearchService<USER> service;
    @Autowired
    private ObjectMapper objectMapper;

    @KafkaListener(topics={"${jima.search.channel}"}, groupId="${spring.kafka.consumer.group-id}")
    public void listener(String message) throws IOException {
        log.debug("Search listener, message {}", (Object)message);
        ChannelMessage channelMessage = (ChannelMessage)this.objectMapper.readValue(message, this.getMessageReferenceType());
        this.receive(channelMessage, Optional.ofNullable(channelMessage.getUser()));
    }

    public BaseSearchService<USER> getSearchService() {
        return this.service;
    }

    public TypeReference<ChannelMessage<USER, SearchMessage>> getMessageReferenceType() {
        return new TypeReference<ChannelMessage<USER, SearchMessage>>(this){};
    }
}

