/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.search.client;

import ir.msob.jima.core.beans.properties.JimaProperties;
import ir.msob.jima.core.commons.client.BaseAsyncClient;
import ir.msob.jima.core.commons.model.channel.ChannelMessage;
import ir.msob.jima.core.commons.model.dto.BaseDto;
import ir.msob.jima.core.commons.model.dto.ModelType;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.search.commons.annotaion.CurrentClass;
import ir.msob.jima.search.commons.annotaion.DomainSearch;
import ir.msob.jima.search.commons.model.SearchMessage;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.modelmapper.ModelMapper;

public interface BaseSearchClient {
    public ModelMapper getModelMapper();

    public BaseAsyncClient getAsyncClient();

    public JimaProperties getJimaProperties();

    default public <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>, USER extends BaseUser<ID>> void insert(DTO dto, Optional<USER> user) {
        this.sendSearchMessage(dto, user, "save");
    }

    default public <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>, USER extends BaseUser<ID>> void update(DTO dto, Optional<USER> user) {
        this.sendSearchMessage(dto, user, "update");
    }

    default public <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>, USER extends BaseUser<ID>> void delete(ID id, Class<DTO> dtoClass, Optional<USER> user) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        DTO dto = this.prepareDto(id, dtoClass);
        this.sendSearchMessage(dto, user, "delete");
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>> DTO prepareDto(ID id, Class<DTO> dtoClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        BaseDto dto = (BaseDto)dtoClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        dto.setDomainId(id);
        return (DTO)dto;
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>, USER extends BaseUser<ID>> void sendSearchMessage(DTO dto, Optional<USER> user, String operation) {
        DomainSearch domainSearch = this.getAuditLogAnnotation(dto);
        if (domainSearch == null) {
            return;
        }
        ChannelMessage<ID, USER, SearchMessage> message = this.prepareChannelMessage(dto, domainSearch, operation);
        this.send(message, user);
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>> Object prepareData(DTO dto, DomainSearch domainSearch) {
        Object data = domainSearch.model() == CurrentClass.class ? dto : this.getModelMapper().map(dto, domainSearch.model());
        return data;
    }

    private <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, DTO extends BaseDto<ID>> ChannelMessage<ID, USER, SearchMessage> prepareChannelMessage(DTO dto, DomainSearch domainSearch, String operation) {
        SearchMessage searchMessage = new SearchMessage();
        searchMessage.setDto(this.prepareData(dto, domainSearch));
        searchMessage.setOperation(operation);
        if (domainSearch.model() == CurrentClass.class) {
            searchMessage.setDtoClass(dto.getClass());
        } else {
            searchMessage.setDtoClass(domainSearch.model());
        }
        ChannelMessage channelMessage = new ChannelMessage();
        channelMessage.setData((ModelType)searchMessage);
        return channelMessage;
    }

    private <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>> void send(ChannelMessage<ID, USER, SearchMessage> message, Optional<USER> user) {
        this.getAsyncClient().send(message, this.getJimaProperties().getSearch().getChannel(), user);
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>> DomainSearch getAuditLogAnnotation(DTO dto) {
        return this.getAuditLogAnnotation(dto.getClass());
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>> DomainSearch getAuditLogAnnotation(Class<DTO> dtoClass) {
        return (DomainSearch)DomainSearch.info.getAnnotation(dtoClass);
    }
}

