/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.search.client;

import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.model.criteria.BaseCriteria;
import ir.msob.jima.core.commons.model.dto.BaseDto;
import ir.msob.jima.core.commons.operation.BaseBeforeAfterOperation;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.search.client.BaseSearchClient;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SearchBeforeAfterService
implements BaseBeforeAfterOperation {
    private final BaseSearchClient searchClient;

    @MethodStats
    public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, DTO extends BaseDto<ID>> void afterSave(DTO dto, DTO savedDto, Optional<USER> user) {
        this.searchClient.insert(savedDto, user);
    }

    @MethodStats
    public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, DTO extends BaseDto<ID>> void afterUpdate(DTO previousDto, DTO updatedDto, Optional<USER> user) {
        this.searchClient.update(updatedDto, user);
    }

    @MethodStats
    public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, DTO extends BaseDto<ID>, C extends BaseCriteria<ID>> void afterDelete(DTO dto, C criteria, Class<DTO> dtoClass, Optional<USER> user) {
        this.searchClient.delete(dto.getDomainId(), dtoClass, user);
    }

    public SearchBeforeAfterService(BaseSearchClient searchClient) {
        this.searchClient = searchClient;
    }
}

