package ir.msob.jima.search.client;

import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.model.criteria.BaseCriteria;
import ir.msob.jima.core.commons.model.dto.BaseDto;
import ir.msob.jima.core.commons.operation.BaseBeforeAfterOperation;
import ir.msob.jima.core.commons.security.BaseUser;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.Optional;

@Service
@RequiredArgsConstructor
public class SearchBeforeAfterService
        implements BaseBeforeAfterOperation {
    private final BaseSearchClient searchClient;

    @MethodStats
    @Override
    public <ID extends Comparable<ID> & Serializable,
            USER extends BaseUser,
            DTO extends BaseDto<ID>> void afterSave(DTO dto, DTO savedDto, Optional<USER> user) {
        searchClient.insert(savedDto, user);
    }

    @MethodStats
    @Override
    public <ID extends Comparable<ID> & Serializable,
            USER extends BaseUser,
            DTO extends BaseDto<ID>> void afterUpdate(DTO previousDto, DTO updatedDto, Optional<USER> user) {
        searchClient.update(updatedDto, user);
    }

    @SneakyThrows
    @MethodStats
    @Override
    public <ID extends Comparable<ID> & Serializable,
            USER extends BaseUser,
            DTO extends BaseDto<ID>,
            C extends BaseCriteria<ID>> void afterDelete(DTO dto, C criteria, Class<DTO> dtoClass, Optional<USER> user) {
        searchClient.delete(dto.getDomainId(), dtoClass, user);
    }
}
