package ir.msob.jima.search.commons.annotaion;

import ir.msob.jima.core.commons.annotation.ClassAnnotationInfo;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface DomainSearch {
    ClassAnnotationInfo<DomainSearch> info = new ClassAnnotationInfo<>(DomainSearch.class);

    @AliasFor("value")
    String indexName() default "";

    @AliasFor("indexName")
    String value() default "";

    Class<?> model() default CurrentClass.class;
}