package ir.msob.jima.search.service;

import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.model.channel.ChannelMessage;
import ir.msob.jima.core.commons.operation.Operations;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.search.commons.model.SearchMessage;

import java.io.Serializable;
import java.util.Optional;

public interface BaseSearchReceiver<ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>> {

    BaseSearchService<ID, USER> getSearchService();

    @MethodStats
    default void receive(ChannelMessage<ID, USER, SearchMessage> channelMessage, Optional<USER> user) {
        if (Operations.SAVES.contains(channelMessage.getData().getOperation())) {
            getSearchService().save(channelMessage.getData().getDto(), channelMessage.getData().getDtoClass(), user).subscribe();
        } else if (Operations.UPDATES.contains(channelMessage.getData().getOperation())) {
            getSearchService().update(channelMessage.getData().getDto(), channelMessage.getData().getDtoClass(), user).subscribe();
        } else if (Operations.DELETES.contains(channelMessage.getData().getOperation())) {
            getSearchService().delete(channelMessage.getData().getDto(), channelMessage.getData().getDtoClass(), user).subscribe();
        }
    }
}
