package ir.msob.jima.search.service;

import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.security.BaseUser;
import reactor.core.publisher.Mono;

import java.util.Optional;

public interface BaseSearchService<USER extends BaseUser> {
    @MethodStats
    Mono<Object> save(Object dto, Class<?> dtoClass, Optional<USER> user);

    @MethodStats
    Mono<Object> update(Object dto, Class<?> dtoClass, Optional<USER> user);

    @MethodStats
    Mono<Boolean> delete(Object dto, Class<?> dtoClass, Optional<USER> user);
}
