/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.security.api.grpc.oauth2;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import lombok.Generated;
import net.devh.boot.grpc.common.security.SecurityConstants;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import net.devh.boot.grpc.server.security.interceptors.AuthenticatingServerInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolder;

@GrpcGlobalServerInterceptor
@Order(value=5100)
public class BaseAuthenticatingServerInterceptor
implements AuthenticatingServerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAuthenticatingServerInterceptor.class);
    private final GrpcAuthenticationReader jwtGrpcAuthenticationReader;

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        String header = (String)metadata.get(SecurityConstants.AUTHORIZATION_HEADER);
        if (StringUtils.isEmpty((CharSequence)header)) {
            log.debug("Authentication header is null");
            return serverCallHandler.startCall(serverCall, metadata);
        }
        try {
            Authentication authentication = this.jwtGrpcAuthenticationReader.readAuthentication(serverCall, metadata);
            if (authentication != null) {
                SecurityContextHolder.getContext().setAuthentication(authentication);
                return serverCallHandler.startCall(serverCall, metadata);
            }
            throw Status.UNAUTHENTICATED.withDescription("Authentication is invalid!").asRuntimeException();
        }
        catch (Exception e) {
            ReactiveSecurityContextHolder.clearContext();
            log.error("Authentication request failed: {}", (Object)e.getMessage(), (Object)e);
            throw Status.UNAUTHENTICATED.withDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException();
        }
    }

    @Generated
    public BaseAuthenticatingServerInterceptor(GrpcAuthenticationReader jwtGrpcAuthenticationReader) {
        this.jwtGrpcAuthenticationReader = jwtGrpcAuthenticationReader;
    }
}

