/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.security.api.restful.oauth2;

import ir.msob.jima.core.beans.properties.JimaProperties;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Configuration
public class WebClientConfiguration {
    @Generated
    private static final Log log = LogFactory.getLog(WebClientConfiguration.class);
    private final JimaProperties jimaProperties;

    private static ExchangeFilterFunction logRequest() {
        return ExchangeFilterFunction.ofRequestProcessor(clientRequest -> {
            log.info((Object)("Request: " + String.valueOf(clientRequest.method()) + " " + String.valueOf(clientRequest.url())));
            return Mono.just((Object)clientRequest);
        });
    }

    @Bean
    @Primary
    public WebClient webClient(WebClient.Builder builder) {
        return builder.build();
    }

    @Bean
    @Primary
    @LoadBalanced
    public WebClient.Builder webClientBuilder(AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager authorizedClientManager) {
        ServerOAuth2AuthorizedClientExchangeFilterFunction oauth = new ServerOAuth2AuthorizedClientExchangeFilterFunction((ReactiveOAuth2AuthorizedClientManager)authorizedClientManager);
        oauth.setDefaultOAuth2AuthorizedClient(true);
        oauth.setDefaultClientRegistrationId(this.jimaProperties.getSecurity().getDefaultClientRegistrationId());
        return WebClient.builder().filter((ExchangeFilterFunction)oauth).filters(exchangeFilterFunctions -> exchangeFilterFunctions.add(WebClientConfiguration.logRequest()));
    }

    @Generated
    public WebClientConfiguration(JimaProperties jimaProperties) {
        this.jimaProperties = jimaProperties;
    }
}

