/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.security.commons;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import reactor.core.publisher.Flux;

public class JwtReactiveRoleConverter
implements Converter<Jwt, Flux<GrantedAuthority>> {
    public Flux<GrantedAuthority> convert(Jwt jwt) {
        List<String> roles = this.extractRoles(jwt);
        return roles.isEmpty() ? Flux.empty() : Flux.fromIterable(roles).map(SimpleGrantedAuthority::new);
    }

    private List<String> extractRoles(Jwt jwt) {
        ArrayList objectRoles = jwt.getClaims().getOrDefault("rls", new ArrayList());
        return objectRoles instanceof List ? ((List)objectRoles).stream().map(Object::toString).toList() : List.of();
    }
}

