/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.security.it;

import com.fasterxml.jackson.databind.ObjectMapper;
import ir.msob.jima.core.beans.properties.JimaProperties;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.core.commons.security.BaseUserService;
import ir.msob.jima.core.commons.security.UserInfoUtil;
import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.util.Strings;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public interface BaseSecurityProjectUserService
extends BaseUserService {
    public JimaProperties getJimaProperties();

    public ObjectMapper getObjectMapper();

    default public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, A extends Authentication> Optional<USER> getUser(A authentication) {
        if (authentication != null) {
            JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)authentication;
            return this.getUser(jwtAuthenticationToken.getTokenAttributes());
        }
        return Optional.empty();
    }

    default public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>> Optional<USER> getUser(String userInfo, Class<USER> userClass) {
        return UserInfoUtil.decodeUser((ObjectMapper)this.getObjectMapper(), (String)userInfo, userClass);
    }

    default public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, P extends Principal> Optional<USER> getUser(P principal) {
        if (principal != null) {
            JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)principal;
            Jwt jwt = (Jwt)jwtAuthenticationToken.getToken();
            return this.getUser(jwt.getClaims());
        }
        return Optional.empty();
    }

    default public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>> Optional<USER> getUser(String userInfo, Map<String, Object> claims, Class<USER> userClass) {
        if (claims.get("sub").equals(this.getJimaProperties().getSecurity().getDefaultClientRegistrationId())) {
            if (Strings.isNotBlank((String)userInfo)) {
                return this.getUser(userInfo, userClass);
            }
            return Optional.empty();
        }
        return this.getUser((Principal)((Object)claims));
    }

    default public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>> Optional<USER> getUser(USER user, Map<String, Object> claims) {
        if (claims.get("sub").equals(this.getJimaProperties().getSecurity().getDefaultClientRegistrationId())) {
            if (user != null) {
                return Optional.of(user);
            }
            return Optional.empty();
        }
        return this.getUser((Principal)((Object)claims));
    }

    default public <ID extends Comparable<ID> & Serializable, USER extends BaseUser<ID>, P extends Principal> Optional<USER> getUser(String userInfo, P principal, Class<USER> userClass) {
        if (principal.getName().equals(this.getJimaProperties().getSecurity().getDefaultClientRegistrationId())) {
            if (Strings.isNotBlank((String)userInfo)) {
                return this.getUser(userInfo, userClass);
            }
            return Optional.empty();
        }
        return this.getUser(principal);
    }
}

