/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.security.ral.keycloak.test;

import dasniko.testcontainers.keycloak.KeycloakContainer;
import ir.msob.jima.core.beans.properties.JimaProperties;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.util.StringUtils;

@TestConfiguration(proxyBeanMethods=false)
public class KeycloakContainerConfiguration {
    @Bean
    public KeycloakContainer keycloakContainer(DynamicPropertyRegistry registry, JimaProperties jimaProperties) {
        String keycloakImage = StringUtils.hasText((String)jimaProperties.getTestContainer().getKeycloak().getImage()) ? jimaProperties.getTestContainer().getKeycloak().getImage() : null;
        KeycloakContainer container = StringUtils.hasText((String)keycloakImage) ? new KeycloakContainer(keycloakImage) : new KeycloakContainer();
        container.withReuse(jimaProperties.getTestContainer().getKeycloak().isReuse());
        container.withRealmImportFile(jimaProperties.getTestContainer().getKeycloak().getRealmJsonFile());
        registry.add("spring.security.oauth2.resource-server.jwt.issuer-uri", () -> container.getAuthServerUrl() + "/realms/" + jimaProperties.getTestContainer().getKeycloak().getRealm());
        return container;
    }
}

