package ir.msob.jima.signature.commons.annotaion;

import ir.msob.jima.core.commons.annotation.ClassAnnotationInfo;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface DomainSignature {
    ClassAnnotationInfo<DomainSignature> info = new ClassAnnotationInfo<>(DomainSignature.class);

    @AliasFor("value")
    String id() default "";

    @AliasFor("id")
    String value() default "";

    boolean throwError() default false;
}