/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.signature.service;

import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.exception.badrequest.BadRequestException;
import ir.msob.jima.core.commons.exception.domainnotfound.DomainNotFoundException;
import ir.msob.jima.core.commons.exception.runtime.CommonRuntimeException;
import ir.msob.jima.core.commons.model.criteria.BaseCriteria;
import ir.msob.jima.core.commons.model.dto.BaseDto;
import ir.msob.jima.core.commons.operation.BaseBeforeAfterOperation;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.signature.commons.annotaion.DomainSignature;
import ir.msob.jima.signature.commons.base.BaseDomainSignature;
import ir.msob.jima.signature.commons.model.SignatureModel;
import ir.msob.jima.signature.commons.model.SignatureStatus;
import ir.msob.jima.signature.service.SignatureService;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Collection;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;

@Service
public class SignatureBeforeAfterOperationService
implements BaseBeforeAfterOperation {
    private final SignatureService signatureService;

    @MethodStats
    public <ID extends Comparable<ID> & Serializable, USER extends BaseUser, DTO extends BaseDto<ID>> void beforeSave(DTO dto, Optional<USER> user) throws DomainNotFoundException, BadRequestException {
        DomainSignature domainSignature = (DomainSignature)DomainSignature.info.getAnnotation(dto.getClass());
        if (domainSignature != null) {
            this.setSignature(domainSignature, dto);
        }
        super.beforeSave(dto, user);
    }

    @MethodStats
    public <ID extends Comparable<ID> & Serializable, USER extends BaseUser, DTO extends BaseDto<ID>> void beforeUpdate(DTO previousDto, DTO dto, Optional<USER> user) throws DomainNotFoundException, BadRequestException {
        DomainSignature domainSignature = (DomainSignature)DomainSignature.info.getAnnotation(previousDto.getClass());
        if (domainSignature != null) {
            if (previousDto instanceof BaseDomainSignature) {
                BaseDomainSignature previousBaseDomainSignature = (BaseDomainSignature)previousDto;
                this.validation(previousDto, domainSignature, previousBaseDomainSignature);
                this.setSignature(domainSignature, dto);
            } else {
                throw new CommonRuntimeException("The Dto must implement the {}. dto class {}", new Object[]{BaseDomainSignature.class, previousDto.getClass()});
            }
        }
        super.beforeUpdate(previousDto, dto, user);
    }

    public <ID extends Comparable<ID> & Serializable, USER extends BaseUser, DTO extends BaseDto<ID>, C extends BaseCriteria<ID>> void afterGet(Collection<ID> ids, Collection<DTO> dtos, C criteria, Optional<USER> user) throws DomainNotFoundException, BadRequestException {
        for (BaseDto dto : dtos) {
            if (!(dto instanceof BaseDomainSignature)) continue;
            BaseDomainSignature baseDomainSignature = (BaseDomainSignature)dto;
            this.initSignatureStatus(baseDomainSignature);
        }
        super.afterGet(ids, dtos, criteria, user);
    }

    private void initSignatureStatus(BaseDomainSignature baseDomainSignature) {
        if (baseDomainSignature.getSignature() == null || Strings.isBlank((String)baseDomainSignature.getSignature().getSignature()) || Strings.isBlank((String)baseDomainSignature.getSignature().getAlgorithmId()) || Strings.isBlank((String)baseDomainSignature.getSignature().getValuesId())) {
            baseDomainSignature.setSignature(new SignatureModel());
            baseDomainSignature.getSignature().setStatus(SignatureStatus.NO_SIGNATURE);
            return;
        }
        if (this.signatureService.validation(baseDomainSignature)) {
            baseDomainSignature.getSignature().setStatus(SignatureStatus.VALID);
        } else {
            baseDomainSignature.getSignature().setStatus(SignatureStatus.INVALID);
        }
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>> void validation(DTO dto, DomainSignature domainSignature, BaseDomainSignature baseDomainSignature) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (baseDomainSignature.getSignature() == null || Strings.isBlank((String)baseDomainSignature.getSignature().getSignature()) || Strings.isBlank((String)baseDomainSignature.getSignature().getAlgorithmId()) || Strings.isBlank((String)baseDomainSignature.getSignature().getValuesId())) {
            throw new CommonRuntimeException("The signature can not be null in update service! id {}", new Object[]{dto.getDomainId()});
        }
        if (domainSignature.throwError() && !this.signatureService.validation(baseDomainSignature)) {
            throw new CommonRuntimeException("The signature of this dto is invalid! id {}", new Object[]{dto.getDomainId()});
        }
    }

    private <ID extends Comparable<ID> & Serializable, DTO extends BaseDto<ID>> void setSignature(DomainSignature domainSignature, DTO dto) throws NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        if (!(dto instanceof BaseDomainSignature)) {
            throw new CommonRuntimeException("The Dto must implement the {}. dto class {}", new Object[]{BaseDomainSignature.class, dto.getClass()});
        }
        BaseDomainSignature baseDomainSignature = (BaseDomainSignature)dto;
        baseDomainSignature.setSignature(this.signatureService.encode(domainSignature, baseDomainSignature));
    }

    @Generated
    public SignatureBeforeAfterOperationService(SignatureService signatureService) {
        this.signatureService = signatureService;
    }
}

