/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.signature.service;

import ir.msob.jima.core.beans.properties.JimaProperties;
import ir.msob.jima.core.commons.exception.runtime.CommonRuntimeException;
import ir.msob.jima.core.commons.properties.SignatureProperties;
import ir.msob.jima.signature.commons.annotaion.DomainSignature;
import ir.msob.jima.signature.commons.base.BaseDomainSignature;
import ir.msob.jima.signature.commons.model.SignatureModel;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Component;

@Component
public class SignatureService {
    private final JimaProperties jimaProperties;
    private static final String PUBLIC_HEADER = "-----BEGIN # PUBLIC KEY-----";
    private static final String PUBLIC_FOOTER = "-----END # PUBLIC KEY-----";
    private static final String PRIVATE_HEADER = "-----BEGIN # PRIVATE KEY-----";
    private static final String PRIVATE_FOOTER = "-----END # PRIVATE KEY-----";

    public <DS extends BaseDomainSignature> SignatureModel encode(DomainSignature domainSignature, DS baseDomainSignature) {
        String signatureId = Strings.isNotBlank((String)domainSignature.value()) ? domainSignature.value() : domainSignature.id();
        SignatureProperties.Algorithm signature = this.jimaProperties.getSignature().getAlgorithms().stream().filter(s -> s.getId().equalsIgnoreCase(signatureId)).filter(SignatureProperties.Algorithm::isEnabled).findFirst().orElseThrow(() -> new CommonRuntimeException("Cannot find enabled signature configuration for the given domain signature", new Object[0]));
        byte[] value = this.prepareValue((List)baseDomainSignature.getSignatureValues().lastEntry().getValue());
        Signature sig = Signature.getInstance(signature.getHashAlgorithm());
        sig.initSign(this.preparePrivateKey(signature));
        sig.update(value);
        byte[] encryptedData = sig.sign();
        return SignatureModel.builder().algorithmId(signature.getId()).valuesId((String)baseDomainSignature.getSignatureValues().lastKey()).signature(Base64.getEncoder().encodeToString(encryptedData)).build();
    }

    private PrivateKey preparePrivateKey(SignatureProperties.Algorithm signature) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = this.prepareKeyBase64(signature, signature.getPrivateKey());
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(signature.getEncryptionAlgorithm());
        return keyFactory.generatePrivate(spec);
    }

    private PublicKey preparePublicKey(SignatureProperties.Algorithm signature) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = this.prepareKeyBase64(signature, signature.getPublicKey());
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(signature.getEncryptionAlgorithm());
        return keyFactory.generatePublic(spec);
    }

    private byte[] prepareKeyBase64(SignatureProperties.Algorithm signature, String key) {
        return Base64.getDecoder().decode(key.replaceFirst(PUBLIC_HEADER.replaceFirst("#", signature.getEncryptionAlgorithm()), "").replaceFirst(PUBLIC_FOOTER.replaceFirst("#", signature.getEncryptionAlgorithm()), "").replaceFirst(PRIVATE_HEADER.replaceFirst("#", signature.getEncryptionAlgorithm()), "").replaceFirst(PRIVATE_FOOTER.replaceFirst("#", signature.getEncryptionAlgorithm()), "").trim().getBytes());
    }

    public <DS extends BaseDomainSignature> boolean validation(DS baseDomainSignature) {
        SignatureProperties.Algorithm signature = this.jimaProperties.getSignature().getAlgorithms().stream().filter(s -> s.getId().equalsIgnoreCase(baseDomainSignature.getSignature().getAlgorithmId())).filter(SignatureProperties.Algorithm::isEnabled).findFirst().orElseThrow(() -> new CommonRuntimeException("Cannot find enabled signature configuration for the given domain signature", new Object[0]));
        byte[] value = this.prepareValue((List)baseDomainSignature.getSignatureValues().get(baseDomainSignature.getSignature().getValuesId()));
        Signature sig = Signature.getInstance(signature.getHashAlgorithm());
        sig.initVerify(this.preparePublicKey(signature));
        sig.update(value);
        byte[] signatureBytes = Base64.getDecoder().decode(baseDomainSignature.getSignature().getSignature());
        return sig.verify(signatureBytes);
    }

    private byte[] prepareValue(List<String> values) {
        return String.join((CharSequence)",", values).getBytes(StandardCharsets.UTF_8);
    }

    @Generated
    public SignatureService(JimaProperties jimaProperties) {
        this.jimaProperties = jimaProperties;
    }
}

