/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.ason;

import com.afollestad.ason.Ason;
import com.afollestad.ason.AsonArray;
import com.afollestad.ason.ClassCacheEntry;
import com.afollestad.ason.Util;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

class AsonSerializer {
    private static AsonSerializer serializer;
    private Map<String, ClassCacheEntry> classCache = new HashMap<String, ClassCacheEntry>(0);

    AsonSerializer() {
    }

    @NotNull
    public static AsonSerializer get() {
        if (serializer == null) {
            serializer = new AsonSerializer();
        }
        return serializer;
    }

    @Nullable
    public Ason serialize(@Nullable Object object) {
        if (Util.isNull(object)) {
            return null;
        }
        if (object instanceof Ason || object instanceof AsonArray || object instanceof JSONObject || object instanceof JSONArray) {
            throw new IllegalArgumentException("You cannot serialize Ason or AsonArray.");
        }
        if (Util.isPrimitive(object)) {
            throw new IllegalArgumentException("You cannot serialize primitive types (" + object.getClass().getName() + ").");
        }
        if (object.getClass().isArray()) {
            throw new IllegalArgumentException("Use Ason.serialize(Object, Class<?>) to serialize arrays.");
        }
        if (Util.isList(object.getClass())) {
            throw new IllegalArgumentException("Use Ason.serialize(Object, Class<?>) to serialize lists.");
        }
        Field[] fields = object.getClass().getDeclaredFields();
        Ason ason = new Ason();
        for (Field field : fields) {
            field.setAccessible(true);
            if (Util.shouldIgnore(field)) continue;
            Object result = this.serializeField(field, object);
            ason.put(Util.fieldName(field), result);
        }
        return ason;
    }

    @Nullable
    public AsonArray serializeArray(@Nullable Object arrayObject) {
        if (Util.isNull(arrayObject)) {
            return null;
        }
        Class<?> cls = arrayObject.getClass();
        if (!cls.isArray()) {
            throw new IllegalArgumentException(cls.getName() + " is not an array type.");
        }
        AsonArray<Object> result = new AsonArray<Object>();
        int length = Array.getLength(arrayObject);
        if (length == 0) {
            return result;
        }
        for (int i = 0; i < length; ++i) {
            Class<?> itemCls;
            Object value = Array.get(arrayObject, i);
            Class<?> clazz = itemCls = cls.getComponentType() == Object.class && value != null ? value.getClass() : cls.getComponentType();
            if (Util.isPrimitive(itemCls)) {
                result.add(value);
                continue;
            }
            result.add(this.serialize(value));
        }
        return result;
    }

    @Nullable
    public AsonArray serializeList(@Nullable List list) {
        if (Util.isNull(list)) {
            return null;
        }
        if (list.isEmpty()) {
            return new AsonArray();
        }
        Class<?> componentType = list.get(0).getClass();
        Object array = Array.newInstance(componentType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return this.serializeArray(array);
    }

    Object serializeField(Field field, Object object) {
        Object fieldValue;
        field.setAccessible(true);
        try {
            fieldValue = field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (Util.isNull(fieldValue)) {
            return null;
        }
        if (Util.isPrimitive(fieldValue) || fieldValue instanceof JSONObject || fieldValue instanceof JSONArray || fieldValue instanceof Ason || fieldValue instanceof AsonArray) {
            return fieldValue;
        }
        if (fieldValue.getClass().isArray()) {
            return this.serializeArray(fieldValue);
        }
        if (Util.isList(fieldValue.getClass())) {
            return this.serializeList((List)fieldValue);
        }
        return this.serialize(fieldValue);
    }

    @Nullable
    public <T> T deserialize(@Nullable Ason ason, @NotNull Class<T> cls) {
        if (Util.isNull(ason)) {
            return null;
        }
        if (Util.isPrimitive(cls)) {
            throw new IllegalArgumentException("You cannot deserialize an object to a primitive type (" + cls.getName() + ").");
        }
        if (cls == AsonArray.class || cls == JSONArray.class) {
            throw new IllegalArgumentException("You cannot deserialize an object to a JSON array.");
        }
        if (cls == Ason.class || cls == JSONObject.class) {
            if (cls == JSONObject.class) {
                return (T)ason.toStockJson();
            }
            return (T)ason;
        }
        ClassCacheEntry<T> cacheEntry = this.classCache.get(cls.getName());
        if (Util.isNull(cacheEntry)) {
            cacheEntry = new ClassCacheEntry<T>(cls);
            this.classCache.put(cls.getName(), cacheEntry);
        }
        Object newObject = cacheEntry.newInstance();
        for (String name : cacheEntry.fields()) {
            AsonArray asonArray;
            Class<?> type = cacheEntry.fieldType(name);
            if (Util.isPrimitive(type) || type == JSONObject.class || type == JSONArray.class || type == Ason.class || type == AsonArray.class) {
                cacheEntry.set(newObject, name, ason.get(name));
                continue;
            }
            if (type.isArray()) {
                asonArray = (AsonArray)ason.get(name);
                cacheEntry.set(newObject, name, this.deserializeArray(asonArray, type));
                continue;
            }
            if (Util.isList(type)) {
                asonArray = (AsonArray)ason.get(name);
                Class<?> listItemType = cacheEntry.listItemType(name);
                cacheEntry.set(newObject, name, this.deserializeList(asonArray, listItemType));
                continue;
            }
            Object value = ason.get(name);
            if (value instanceof Ason) {
                Ason asonObject = (Ason)value;
                cacheEntry.set(newObject, name, this.deserialize(asonObject, type));
                continue;
            }
            AsonArray asonArray2 = (AsonArray)value;
            cacheEntry.set(newObject, name, this.deserializeArray(asonArray2, type));
        }
        return newObject;
    }

    @Nullable
    public <T> T deserializeArray(@Nullable AsonArray json, @NotNull Class<T> cls) {
        if (Util.isNull(json)) {
            return null;
        }
        if (!cls.isArray() && cls != Object.class) {
            if (Util.isList(cls)) {
                throw new IllegalArgumentException("Use Ason.deserializeList() for Lists, not deserializeArray().");
            }
            throw new IllegalArgumentException(cls.getName() + " is not an array type.");
        }
        Class component = cls == Object.class ? Object.class : cls.getComponentType();
        Object newArray = Array.newInstance(component, json.size());
        if (json.isEmpty()) {
            return (T)newArray;
        }
        for (int i = 0; i < json.size(); ++i) {
            AsonArray subArray;
            Class itemType;
            Object item = json.get(i);
            if (Util.isNull(item)) {
                Array.set(newArray, i, Util.defaultPrimitiveValue(component));
                continue;
            }
            Class clazz = itemType = component == Object.class ? item.getClass() : component;
            if (Util.isPrimitive(itemType)) {
                if (itemType == Character.TYPE || itemType == Character.class) {
                    item = Character.valueOf(((String)item).charAt(0));
                } else if (itemType == Short.TYPE || itemType == Short.class) {
                    item = Short.parseShort(Integer.toString((Integer)item));
                }
                Array.set(newArray, i, item);
                continue;
            }
            if (itemType.isArray()) {
                subArray = (AsonArray)item;
                Array.set(newArray, i, this.deserializeArray(subArray, component));
                continue;
            }
            if (Util.isList(itemType)) {
                subArray = (AsonArray)item;
                if (subArray.isEmpty()) {
                    Array.set(newArray, i, new ArrayList(0));
                    continue;
                }
                Class<?> listComponent = subArray.get(0).getClass();
                Array.set(newArray, i, this.deserializeList(subArray, listComponent));
                continue;
            }
            if (!(item instanceof Ason)) {
                throw new IllegalStateException("Expected JSON array to contain JSON objects to deserialize to " + itemType.getName() + ", found " + item.getClass().getName() + " objects instead.");
            }
            Ason subObject = (Ason)item;
            Array.set(newArray, i, this.deserialize(subObject, itemType));
        }
        return (T)newArray;
    }

    @Nullable
    public <T> List<T> deserializeList(@Nullable AsonArray json, @NotNull Class<T> cls) {
        if (Util.isNull(json)) {
            return null;
        }
        if (json.isEmpty()) {
            return new ArrayList(0);
        }
        Class<?> arrayType = Array.newInstance(cls, 0).getClass();
        Object array = this.deserializeArray(json, arrayType);
        int length = Array.getLength(array);
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            result.add(Array.get(array, i));
        }
        return result;
    }
}

