/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.ason;

import com.afollestad.ason.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

class ClassCacheEntry<T> {
    private final Class<T> cls;
    private final Constructor<?> ctor;
    private final HashMap<String, Field> fieldMap;
    private final HashMap<String, Class<?>> listGenericTypeMap;

    ClassCacheEntry(Class<T> cls) {
        Field[] fields;
        this.cls = cls;
        this.fieldMap = new HashMap(4);
        this.ctor = Util.getDefaultConstructor(cls);
        this.listGenericTypeMap = new HashMap(0);
        for (Field field : fields = cls.getDeclaredFields()) {
            field.setAccessible(true);
            if (Util.shouldIgnore(field)) continue;
            String name = Util.fieldName(field);
            this.fieldMap.put(name, field);
            if (field.getType() != List.class) continue;
            this.listGenericTypeMap.put(name, Util.listGenericType(field));
        }
    }

    Set<String> fields() {
        return this.fieldMap.keySet();
    }

    Class<?> fieldType(String name) {
        return this.fieldMap.get(name).getType();
    }

    Class<?> listItemType(String fieldName) {
        return this.listGenericTypeMap.get(fieldName);
    }

    T newInstance() {
        try {
            return (T)this.ctor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to instantiate " + this.cls.getName(), t);
        }
    }

    void set(Object obj, String name, Object value) {
        Field field = this.fieldMap.get(name);
        Util.setFieldValue(field, obj, value);
    }
}

