/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.ason;

import com.afollestad.ason.AsonArray;
import com.afollestad.ason.AsonSerializer;
import com.afollestad.ason.InvalidJsonException;
import com.afollestad.ason.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Ason {
    private JSONObject json;
    private AsonSerializer serializer;
    private boolean loadedMyFields;

    public Ason(@NotNull JSONObject stock) {
        this.json = stock;
        this.serializer = AsonSerializer.get();
    }

    public Ason() {
        this(new JSONObject());
    }

    public Ason(@NotNull Map<String, Object> map) {
        this();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            this.put(key, value);
        }
    }

    public Ason(@Nullable String json) {
        if (json == null) {
            this.json = new JSONObject();
            return;
        }
        try {
            this.json = new JSONObject(json);
        }
        catch (JSONException e) {
            throw new InvalidJsonException(json, e);
        }
    }

    public static Ason serialize(@Nullable Object object) {
        return AsonSerializer.get().serialize(object);
    }

    public static <T> AsonArray<T> serializeArray(@Nullable Object object) {
        return AsonSerializer.get().serializeArray(object);
    }

    public static <T> AsonArray<T> serializeList(@Nullable List<T> object) {
        return AsonSerializer.get().serializeList(object);
    }

    public static <T> T deserialize(@Nullable String json, @NotNull Class<T> cls) {
        if (Util.isJsonArray(json)) {
            AsonArray ason = new AsonArray(json);
            return AsonSerializer.get().deserializeArray(ason, cls);
        }
        Ason ason = new Ason(json);
        return AsonSerializer.get().deserialize(ason, cls);
    }

    public static <T> T deserialize(@Nullable Ason json, @NonNls Class<T> cls) {
        return AsonSerializer.get().deserialize(json, cls);
    }

    public static <T> T deserialize(@Nullable AsonArray json, @NonNls Class<T> cls) {
        return AsonSerializer.get().deserializeArray(json, cls);
    }

    public static <T> List<T> deserializeList(@Nullable String json, @NotNull Class<T> cls) {
        AsonArray array = new AsonArray(json);
        return AsonSerializer.get().deserializeList(array, cls);
    }

    public static <T> List<T> deserializeList(@Nullable AsonArray json, @NotNull Class<T> cls) {
        return AsonSerializer.get().deserializeList(json, cls);
    }

    private Ason putInternal(JSONArray intoArray, JSONObject intoObject, String key, Object value) {
        this.invalidateLoadedFields();
        if (value == null || JSONObject.NULL.equals(value) || JSONObject.NULL == value) {
            this.json.put(key, JSONObject.NULL);
            return this;
        }
        if (Util.isPrimitive(value) || value instanceof JSONObject || value instanceof JSONArray) {
            if (value instanceof Byte) {
                value = ((Byte)value).intValue();
            } else if (value instanceof Character) {
                value = value.toString();
            }
            if (intoArray != null) {
                intoArray.put(value);
            } else {
                this.json.put(key, value);
            }
        } else if (value instanceof Ason) {
            this.putInternal(intoArray, intoObject, key, ((Ason)value).toStockJson());
        } else if (value instanceof AsonArray) {
            this.putInternal(intoArray, intoObject, key, ((AsonArray)value).toStockJson());
        } else if (value.getClass().isArray()) {
            this.putInternal(intoArray, intoObject, key, this.serializer.serializeArray(value));
        } else if (Util.isList(value.getClass())) {
            this.putInternal(intoArray, intoObject, key, this.serializer.serializeList((List)value));
        } else {
            this.putInternal(intoArray, intoObject, key, this.serializer.serialize(value));
        }
        return this;
    }

    public Ason putNull(@NotNull String key) {
        return this.put(key, JSONObject.NULL);
    }

    public Ason put(@NotNull String key, Object ... values) {
        Object insertObject;
        if (values == null || values.length == 1) {
            insertObject = values != null ? values[0] : JSONObject.NULL;
        } else {
            JSONArray newArray = new JSONArray();
            for (Object value : values) {
                this.putInternal(newArray, null, null, value);
            }
            insertObject = newArray;
        }
        if (key.contains(".")) {
            String[] splitKey = Util.splitPath(key);
            Object target = Util.followPath(this.json, key, splitKey, true);
            if (target instanceof JSONArray) {
                JSONArray arrayTarget = (JSONArray)target;
                String indexKey = splitKey[splitKey.length - 1].substring(1);
                int insertIndex = Integer.parseInt(indexKey);
                if (insertIndex > arrayTarget.length() - 1) {
                    arrayTarget.put(insertObject);
                } else {
                    arrayTarget.put(insertIndex, insertObject);
                }
            } else {
                ((JSONObject)target).put(splitKey[splitKey.length - 1], insertObject);
            }
        } else {
            this.putInternal(null, null, key, insertObject);
        }
        return this;
    }

    public Ason remove(@NotNull String key) {
        String[] splitKey = Util.splitPath(key);
        if (splitKey.length == 1) {
            this.json.remove(key);
        } else {
            Object followed = Util.followPath(this.json, key, splitKey, false);
            if (followed == null) {
                return this;
            }
            if (followed instanceof JSONArray) {
                JSONArray followedArray = (JSONArray)followed;
                int insertIndex = Integer.parseInt(splitKey[splitKey.length - 1].substring(1));
                followedArray.remove(insertIndex);
            } else {
                ((JSONObject)followed).remove(splitKey[splitKey.length - 1]);
            }
        }
        return this;
    }

    @Nullable
    public <T> T get(@NotNull String key) {
        return this.get(key, (T)null);
    }

    public <T> T get(@NotNull String key, @Nullable T defaultValue) {
        Object result;
        if (key.contains(".")) {
            String[] splitKey = Util.splitPath(key);
            result = Util.getPathValue(this.json, key, splitKey);
        } else {
            result = this.json.opt(key);
        }
        if (result == null || JSONObject.NULL.equals(result) || JSONObject.NULL == result) {
            return defaultValue;
        }
        if (result instanceof JSONObject) {
            result = new Ason((JSONObject)result);
        } else if (result instanceof JSONArray) {
            result = new AsonArray((JSONArray)result);
        }
        if (result instanceof Float) {
            result = Float.valueOf(((Float)result).floatValue()).doubleValue();
        }
        return (T)result;
    }

    public boolean getBool(@NotNull String key) {
        return this.getBool(key, false);
    }

    public boolean getBool(@NotNull String key, boolean defaultValue) {
        return this.get(key, defaultValue);
    }

    @Nullable
    public String getString(@NotNull String key) {
        return this.getString(key, null);
    }

    @Nullable
    public String getString(@NotNull String key, @Nullable String defaultValue) {
        return this.get(key, defaultValue);
    }

    public short getShort(@NotNull String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(@NotNull String key, short defaultValue) {
        return this.get(key, defaultValue);
    }

    public int getInt(@NotNull String key) {
        return this.getInt(key, 0);
    }

    public int getInt(@NotNull String key, int defaultValue) {
        return this.get(key, defaultValue);
    }

    public long getLong(@NotNull String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(@NotNull String key, long defaultValue) {
        return this.get(key, defaultValue);
    }

    public float getFloat(@NotNull String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(@NotNull String key, float defaultValue) {
        double value = this.getDouble(key, Float.valueOf(defaultValue).doubleValue());
        return Double.valueOf(value).floatValue();
    }

    public double getDouble(@NotNull String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(@NotNull String key, double defaultValue) {
        return this.get(key, defaultValue);
    }

    @Nullable
    public Character getChar(@NotNull String key) {
        return this.getChar(key, null);
    }

    @Nullable
    public Character getChar(@NotNull String key, @Nullable Character defaultValue) {
        String value = this.getString(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    public byte getByte(@NonNls String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(@NonNls String key, byte defaultValue) {
        return (byte)this.getInt(key, defaultValue);
    }

    public Ason getJsonObject(@NotNull String key) {
        return this.get(key, (Ason)null);
    }

    public <IT> AsonArray<IT> getJsonArray(@NotNull String key) {
        return this.get(key, (AsonArray)null);
    }

    public <T> T get(@NotNull String key, @NotNull Class<T> cls) {
        return this.get(key, cls, null);
    }

    public <T> T get(@NotNull String key, @NotNull Class<T> cls, @Nullable T defaultValue) {
        Object value = this.get(key, (T)null);
        if (Util.isNull(value)) {
            return defaultValue;
        }
        if (Util.isPrimitive(cls) || cls == JSONObject.class || cls == JSONArray.class || cls == Ason.class || cls == AsonArray.class) {
            return (T)value;
        }
        if (cls.isArray()) {
            if (!(value instanceof AsonArray)) {
                throw new IllegalStateException("Expected a AsonArray to convert to " + cls.getName() + ", found " + value.getClass().getName() + ".");
            }
            AsonArray array = (AsonArray)value;
            return AsonSerializer.get().deserializeArray(array, cls);
        }
        if (Util.isList(cls)) {
            throw new IllegalStateException("Use getList(String, Class) instead of get(String, Class) for deserializing arrays to Lists.");
        }
        if (!(value instanceof Ason)) {
            throw new IllegalStateException("Expected a Ason to convert to " + cls.getName() + ", found " + value.getClass().getName() + ".");
        }
        Ason object = (Ason)value;
        return AsonSerializer.get().deserialize(object, cls);
    }

    @Nullable
    public <T> List<T> getList(@NotNull String key, Class<T> itemCls) {
        Object value = this.get(key, (T)null);
        if (Util.isNull(value)) {
            return null;
        }
        if (!(value instanceof AsonArray)) {
            throw new IllegalStateException("Expected a AsonArray to convert to List, found " + value.getClass().getName() + ".");
        }
        AsonArray array = (AsonArray)value;
        return AsonSerializer.get().deserializeList(array, itemCls);
    }

    public boolean has(@NotNull String key) {
        return this.get(key) != null;
    }

    public boolean equal(@NotNull String key, @Nullable Object value) {
        Object actual = this.get(key);
        if (actual == null) {
            return value == null;
        }
        return actual.equals(value);
    }

    public boolean isNull(String key) {
        Object value = this.get(key);
        return Util.isNull(value);
    }

    public int hashCode() {
        return this.json.hashCode();
    }

    public int size() {
        this.invalidateLoadedFields();
        return this.json.length();
    }

    public JSONObject toStockJson() {
        return this.json;
    }

    private void invalidateLoadedFields() {
        Field[] fields;
        if (this.loadedMyFields) {
            return;
        }
        this.loadedMyFields = true;
        for (Field f : fields = this.getClass().getDeclaredFields()) {
            if (Modifier.isPrivate(f.getModifiers()) || Util.shouldIgnore(f)) continue;
            f.setAccessible(true);
            String name = Util.fieldName(f);
            try {
                this.put(name, f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Ason && ((Ason)obj).json.toString().equals(this.json.toString());
    }

    public String toString() {
        this.invalidateLoadedFields();
        return this.json.toString();
    }

    public String toString(int indentSpaces) {
        this.invalidateLoadedFields();
        try {
            return this.json.toString(indentSpaces);
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T deserialize(@NonNls Class<T> cls) {
        return Ason.deserialize(this, cls);
    }
}

