/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.ason;

import com.afollestad.ason.Ason;
import com.afollestad.ason.AsonSerializer;
import com.afollestad.ason.InvalidJsonException;
import com.afollestad.ason.InvalidPathException;
import com.afollestad.ason.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AsonArray<T>
implements Iterable<T> {
    private final JSONArray array;

    public AsonArray() {
        this.array = new JSONArray();
    }

    public AsonArray(@Nullable String json) {
        if (json == null) {
            this.array = new JSONArray();
            return;
        }
        try {
            this.array = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new InvalidJsonException(json, e);
        }
    }

    AsonArray(@NotNull JSONArray internalArray) {
        this.array = internalArray;
    }

    private void putInternal(Object object) {
        Object insertObject;
        if (object == null || JSONObject.NULL.equals(object) || JSONObject.NULL == object) {
            insertObject = JSONObject.NULL;
        } else if (Util.isPrimitive(object.getClass()) || object instanceof JSONObject || object instanceof JSONArray) {
            insertObject = object;
        } else if (object instanceof Ason) {
            insertObject = ((Ason)object).toStockJson();
        } else if (object instanceof AsonArray) {
            insertObject = ((AsonArray)object).toStockJson();
        } else if (object.getClass().isArray()) {
            insertObject = AsonSerializer.get().serializeArray(object);
            if (insertObject != null) {
                insertObject = ((AsonArray)insertObject).toStockJson();
            }
        } else if (Util.isList(object.getClass())) {
            insertObject = AsonSerializer.get().serializeList((List)object);
            if (insertObject != null) {
                insertObject = ((AsonArray)insertObject).toStockJson();
            }
        } else {
            insertObject = AsonSerializer.get().serialize(object);
            if (insertObject != null) {
                insertObject = ((Ason)insertObject).toStockJson();
            }
        }
        this.array.put(insertObject);
    }

    public AsonArray<T> addNull() {
        this.putInternal(JSONObject.NULL);
        return this;
    }

    public AsonArray<T> add(T ... objects) {
        if (objects != null) {
            for (T obj : objects) {
                this.putInternal(obj);
            }
        } else {
            this.putInternal(JSONObject.NULL);
        }
        return this;
    }

    public AsonArray<T> addObjects(Ason ... objects) {
        if (objects != null) {
            for (Ason obj : objects) {
                this.putInternal(obj);
            }
        } else {
            this.putInternal(JSONObject.NULL);
        }
        return this;
    }

    public AsonArray<T> addArrays(AsonArray ... arrays) {
        if (arrays != null) {
            for (AsonArray ary : arrays) {
                this.putInternal(ary);
            }
        } else {
            this.putInternal(JSONObject.NULL);
        }
        return this;
    }

    @Nullable
    public T get(int index) {
        AsonArray<T> value = this.array.opt(index);
        if (value instanceof JSONObject) {
            value = new Ason((JSONObject)((Object)value));
        } else if (value instanceof JSONArray) {
            value = new AsonArray<T>((JSONArray)((Object)value));
        }
        if (Util.isNull(value)) {
            return null;
        }
        return (T)value;
    }

    @Nullable
    public Ason getJsonObject(int index) {
        if (index < 0 || index > this.array.length() - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for this array!");
        }
        JSONObject object = this.array.optJSONObject(index);
        if (Util.isNull(object)) {
            return null;
        }
        return new Ason(object);
    }

    @Nullable
    public <IT> AsonArray<IT> getJsonArray(int index) {
        if (index < 0 || index > this.array.length() - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for this array!");
        }
        JSONArray ary = this.array.optJSONArray(index);
        if (Util.isNull(ary)) {
            return null;
        }
        return new AsonArray<T>(ary);
    }

    Object getInternal(int index, @Nullable String path) {
        if (index < 0 || index > this.array.length() - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for this array!");
        }
        Object value = this.array.opt(index);
        if (path != null) {
            if (Util.isNull(value)) {
                return null;
            }
            if (!(value instanceof JSONObject) && !(value instanceof Ason)) {
                throw new IllegalStateException("Cannot get from an AsonArray using a path when array items are not objects (they're probably primitives).");
            }
            value = Util.getPathValue((JSONObject)value, path, Util.splitPath(path));
        }
        if (Util.isNull(value)) {
            return null;
        }
        return value;
    }

    public <IT> List<IT> getList(int index, @NotNull Class<IT> itemTypeCls) {
        return this.getList(index, null, itemTypeCls);
    }

    public <IT> List<IT> getList(int index, @Nullable String path, @NotNull Class<IT> itemTypeCls) {
        Object value = this.getInternal(index, null);
        if (Util.isNull(value)) {
            return null;
        }
        if (Util.isList(itemTypeCls)) {
            throw new IllegalArgumentException("itemTypeCls should be the class of the items contained in the resulting List.");
        }
        if (!(value instanceof JSONArray)) {
            throw new IllegalStateException("Cannot use getList() on an array which does not contain JSON arrays.");
        }
        return AsonSerializer.get().deserializeList(new AsonArray<T>((JSONArray)value), itemTypeCls);
    }

    public T get(int index, Class<T> cls) {
        return this.get(index, null, cls);
    }

    public T get(int index, @Nullable String path) {
        return this.get(index, path, null);
    }

    public T get(int index, @Nullable String path, Class<T> cls) {
        if (Util.isList(cls)) {
            throw new IllegalStateException("Use AsonArray.getList(...) to retrieve List<> children instead of get(...).");
        }
        Object value = this.getInternal(index, path);
        if (path != null && value != null) {
            cls = value.getClass();
        }
        if (Util.isNull(value)) {
            return null;
        }
        if (Util.isPrimitive(cls) || cls == JSONObject.class || cls == JSONArray.class || cls == Ason.class || cls == AsonArray.class) {
            return (T)value;
        }
        if (cls.isArray()) {
            AsonArray<T> array = new AsonArray<T>((JSONArray)value);
            return (T)AsonSerializer.get().deserializeArray(array, cls);
        }
        Ason object = new Ason((JSONObject)value);
        return (T)AsonSerializer.get().deserialize(object, cls);
    }

    public AsonArray<T> remove(int index) {
        if (index < 0 || index > this.array.length() - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for this array!");
        }
        this.array.remove(index);
        return this;
    }

    public boolean equal(int index, @Nullable T value) {
        T actual = this.get(index);
        if (Util.isNull(actual)) {
            return Util.isNull(value);
        }
        return actual.equals(value);
    }

    public boolean equal(int index, String path, @Nullable Object value) {
        if (index < 0 || index > this.array.length() - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for this array!");
        }
        T arrayEntry = this.get(index);
        if (Util.isNull(arrayEntry)) {
            return Util.isNull(value);
        }
        if (!(arrayEntry instanceof JSONObject) && !(arrayEntry instanceof Ason)) {
            throw new InvalidPathException("You cannot use equal(int, String, Object) in AsonArray<T> when the array contains primitives (" + arrayEntry.getClass().getName() + ").");
        }
        JSONObject encloser = ((Ason)arrayEntry).toStockJson();
        Object pathValue = Util.getPathValue(encloser, path, Util.splitPath(path));
        if (Util.isNull(pathValue)) {
            return Util.isNull(value);
        }
        return pathValue.equals(value);
    }

    public int size() {
        return this.array.length();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @NotNull
    public List<T> toList() {
        ArrayList<T> list = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            T val = this.get(i);
            list.add(val);
        }
        return list;
    }

    public JSONArray toStockJson() {
        return this.array;
    }

    @Override
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    public String toString() {
        return this.array.toString();
    }

    public String toString(int indentSpaces) {
        try {
            return this.array.toString(indentSpaces);
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public <R> R deserialize(Class<?> cls) {
        return (R)Ason.deserialize(this, cls);
    }

    public List<T> deserializeList(Class<T> cls) {
        return Ason.deserializeList(this, cls);
    }
}

