/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.ason;

import com.afollestad.ason.AsonIgnore;
import com.afollestad.ason.AsonName;
import com.afollestad.ason.InvalidPathException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

class Util {
    Util() {
        throw new IllegalStateException("Util shouldn't be constructed!");
    }

    static String[] splitPath(String key) {
        ArrayList<String> result = new ArrayList<String>(4);
        int start = 0;
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) != '.' || i > 0 && key.charAt(i - 1) == '\\') continue;
            String entry = key.substring(start, i).replace("\\.", ".");
            result.add(entry);
            start = i + 1;
        }
        result.add(key.substring(start).replace("\\.", "."));
        return result.toArray(new String[result.size()]);
    }

    static boolean isNumber(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    static Object followPath(JSONObject wrapper, String key, String[] splitKey, boolean createMissing) {
        Object parent = wrapper.opt(splitKey[0]);
        if (!(Util.isNull(parent) || parent instanceof JSONObject || parent instanceof JSONArray)) {
            throw new InvalidPathException("First component of key " + key + " refers to " + splitKey[0] + ", which is not an object or array (it's a " + parent.getClass().getName() + ").");
        }
        if (Util.isNull(parent)) {
            if (createMissing) {
                parent = splitKey[0].startsWith("$") || splitKey.length > 1 && splitKey[1].startsWith("$") ? new JSONArray() : new JSONObject();
                wrapper.put(splitKey[0], parent);
            } else {
                return null;
            }
        }
        for (int i = 1; i < splitKey.length - 1; ++i) {
            String currentKey = splitKey[i];
            if (currentKey.startsWith("\\$")) {
                currentKey = currentKey.substring(1);
            } else if (currentKey.startsWith("$") && Util.isNumber(currentKey.substring(1))) {
                int index = Integer.parseInt(currentKey.substring(1));
                if (!(parent instanceof JSONArray)) {
                    throw new InvalidPathException("Cannot use index notation on objects (" + currentKey + " in " + key + ")!");
                }
                Object current = ((JSONArray)parent).opt(index);
                if (Util.isNull(current)) {
                    if (createMissing) {
                        if (i < splitKey.length - 1 && splitKey[i + 1].startsWith("$")) {
                            current = new JSONArray();
                            ((JSONArray)parent).put(current);
                        } else {
                            current = new JSONObject();
                            ((JSONArray)parent).put(current);
                        }
                    } else {
                        return null;
                    }
                }
                parent = current;
                continue;
            }
            Object current = ((JSONObject)parent).opt(currentKey);
            if (!(Util.isNull(current) || current instanceof JSONObject || current instanceof JSONArray)) {
                return null;
            }
            if (Util.isNull(current)) {
                if (createMissing) {
                    current = i < splitKey.length - 1 && splitKey[i + 1].startsWith("$") ? new JSONArray() : new JSONObject();
                    ((JSONObject)parent).put(currentKey, current);
                } else {
                    return null;
                }
            }
            parent = current;
        }
        return parent;
    }

    @Nullable
    static <T> T getPathValue(JSONObject wrapper, String key, String[] splitKey) {
        if (splitKey.length == 1) {
            return (T)wrapper.opt(key);
        }
        Object target = Util.followPath(wrapper, key, splitKey, false);
        if (Util.isNull(target)) {
            return null;
        }
        String lastKey = splitKey[splitKey.length - 1];
        if (target instanceof JSONObject) {
            return (T)((JSONObject)target).opt(lastKey);
        }
        if (target instanceof JSONArray && lastKey.startsWith("$") && Util.isNumber(lastKey.substring(1))) {
            int index = Integer.parseInt(lastKey.substring(1));
            return (T)((JSONArray)target).opt(index);
        }
        throw new InvalidPathException("Cannot get a value from a JSONArray using a name key (" + lastKey + ").");
    }

    static Constructor<?> getDefaultConstructor(Class<?> cls) {
        Constructor<?>[] constructorArray = cls.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (Constructor<?> ct : constructorArray) {
            if ((ct.getParameterTypes() == null || ct.getParameterTypes().length == 0) && (constructor = ct).getGenericParameterTypes().length == 0) break;
        }
        if (constructor == null) {
            throw new IllegalStateException("No default constructor found for " + cls.getName());
        }
        constructor.setAccessible(true);
        return constructor;
    }

    static boolean isPrimitive(Class<?> cls) {
        return cls == Boolean.TYPE || cls == Boolean.class || cls == Double.TYPE || cls == Double.class || cls == Float.TYPE || cls == Float.class || cls == Short.TYPE || cls == Short.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == String.class || cls == Byte.TYPE || cls == Byte.class || cls == Character.TYPE || cls == Character.class;
    }

    static boolean isPrimitive(Object cls) {
        return cls instanceof Boolean || cls instanceof Double || cls instanceof Float || cls instanceof Short || cls instanceof Integer || cls instanceof Long || cls instanceof String || cls instanceof Byte || cls instanceof Character;
    }

    static Object defaultPrimitiveValue(Class<?> primitiveCls) {
        if (primitiveCls == Boolean.TYPE) {
            return false;
        }
        if (primitiveCls == Double.TYPE) {
            return 0.0;
        }
        if (primitiveCls == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (primitiveCls == Short.TYPE) {
            return (short)0;
        }
        if (primitiveCls == Integer.TYPE) {
            return 0;
        }
        if (primitiveCls == Long.TYPE) {
            return 0L;
        }
        if (primitiveCls == Byte.TYPE) {
            return (byte)0;
        }
        if (primitiveCls == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    static boolean isList(Class<?> cls) {
        Class<?>[] is;
        if (cls == null) {
            return false;
        }
        if (cls.equals(List.class)) {
            return true;
        }
        for (Class<?> i : is = cls.getInterfaces()) {
            if (!i.equals(List.class)) continue;
            return true;
        }
        return false;
    }

    static boolean shouldIgnore(Field field) {
        return field.getName().startsWith("this$") || field.getName().equals("$jacocoData") || field.getAnnotation(AsonIgnore.class) != null;
    }

    static String fieldName(Field field) {
        AsonName annotation = field.getAnnotation(AsonName.class);
        if (annotation != null) {
            return annotation.name();
        }
        return field.getName();
    }

    static void setFieldValue(Field field, Object object, Object value) {
        if (field == null || value == null) {
            return;
        }
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set the value of " + field.getName() + " in " + object.getClass().getName(), e);
        }
    }

    static boolean isJsonArray(@Nullable String json) {
        if (json == null) {
            return false;
        }
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (Character.isAlphabetic(c) || c == '{') {
                return false;
            }
            if (c != '[') continue;
            return true;
        }
        return false;
    }

    static Class<?> listGenericType(Field field) {
        ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
        return (Class)stringListType.getActualTypeArguments()[0];
    }

    static boolean isNull(@Nullable Object value) {
        return value == null || JSONObject.NULL.equals(value) || JSONObject.NULL == value;
    }
}

