package sdk.main.core;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;

abstract class ModuleBase {
    final CoreInternal _int;

    ModuleBase(CoreInternal coreInternal) {
        _int = coreInternal;
    }

    void halt() {
        throw new UnsupportedOperationException();
    }

    /**
     * Called manually by a intrack call from the developer
     *
     * @param newConfig
     */
    void onConfigurationChanged(Configuration newConfig) {
    }

    /**
     * Called manually by a intrack call from the developer
     */
    void onActivityStarted(Activity activity) {
    }

    /**
     * Called manually by a intrack call from the developer
     */
    void onActivityStopped() {
    }

    void callbackOnActivityCreated(Activity activity, Bundle bundle) {
    }

    void callbackOnActivityStarted(Activity activity) {
    }

    void callbackOnActivityResumed(Activity activity) {
    }

    void callbackOnActivityPaused(Activity activity) {
    }

    void callbackOnActivityStopped(Activity activity) {
    }

    void callbackOnActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    void callbackOnActivityDestroyed(Activity activity) {
    }

    void deviceIdChanged() {
    }

    void initFinished(Config config) {
    }
}
