package sdk.main.core;

import android.content.Intent;

import ir.intrack.android.sdk.BuildConfig;

class ModuleConsent extends ModuleBase {

    Consent consentInterface = null;

    ModuleLog L;

    ModuleConsent(CoreInternal coreInternal, Config config) {
        super(coreInternal);

        L = coreInternal.L;

        L.v("[ModuleConsent] Initialising");

        consentInterface = new Consent();
    }

    @Override
    void initFinished(Config config) {
        if (_int.requiresConsent) {
            //do delayed push consent action, if needed
            if (_int.delayedPushConsent != null) {
                _int.doPushConsentSpecialAction(_int.delayedPushConsent);
            }

            //remove persistent push flag if no push consent was set
            if (!_int.featureConsentValues.containsKey(CoreProxy.SdkFeatureNames.push)) {
                _int.doPushConsentSpecialAction(false);
            }

            //do delayed location erasure, if needed
            if (_int.delayedLocationErasure) {
                _int.doLocationConsentSpecialErasure();
            }

            //send collected consent changes that were made before initialization
            if (_int.collectedConsentChanges.size() != 0) {
                for (String changeItem : _int.collectedConsentChanges) {
                    _int.connectionQueue_.sendConsentChanges(changeItem);
                }
                _int.collectedConsentChanges.clear();
            }

            _int.context_.sendBroadcast(new Intent(_int.CONSENT_BROADCAST));

            if (L.logEnabled()) {
                L.d("[ModuleConsent] [Init] [ " + BuildConfig.FLAVOR + " ] is initialized with the current consent state:");
                _int.checkAllConsent();
            }
        }
    }

    @Override
    void halt() {
        consentInterface = null;
    }

    public class Consent {
        /**
         * Print the consent values of all features
         *
         * @return Returns link  for call chaining
         */
        public void checkAllConsent() {
            synchronized (_int) {
                L.i("[Consent] calling checkAllConsent");

                _int.checkAllConsent();
            }
        }

        /**
         * Get the current consent state of a feature
         *
         * @param featureName the name of a feature for which consent should be checked
         * @return the consent value
         */
        public boolean getConsent(String featureName) {
            synchronized (_int) {
                return _int.getConsent(featureName);
            }
        }

        /**
         * Remove consent for all features
         *
         * @return Returns link to CoreProxy for call chaining
         */
        public void removeConsentAll() {
            synchronized (_int) {
                _int.removeConsentAll();
            }
        }

        /**
         * Remove the consent of a feature
         *
         * @param featureNames the names of features for which consent should be removed
         * @return Returns link to CoreProxy for call chaining
         */
        public void removeConsent(String[] featureNames) {
            synchronized (_int) {
                _int.removeConsent(featureNames);
            }
        }

        /**
         * Gives consent for all features
         *
         * @return Returns link to CoreProxy for call chaining
         */
        public void giveConsentAll() {
            synchronized (_int) {
                L.i("[Consent] Giving consent for all features");

                if (!_int.isInitialized()) {
                    L.w("[Consent] Calling this before initialising the SDK is deprecated!");
                }

                giveConsent(_int.validFeatureNames);
            }
        }

        /**
         * Give the consent to a feature
         *
         * @param featureNames the names of features for which consent should be given
         * @return Returns link to CoreProxy for call chaining
         */
        public void giveConsent(String[] featureNames) {
            synchronized (_int) {
                giveConsent(featureNames);
            }
        }

        /**
         * Set the consent of a feature
         *
         * @param featureNames   feature names for which consent should be changed
         * @param isConsentGiven the consent value that should be set
         * @return Returns link to CoreProxy for call chaining
         */
        public void setConsent(String[] featureNames, boolean isConsentGiven) {
            synchronized (_int) {
                _int.setConsentInternal(featureNames, isConsentGiven);
            }
        }

        /**
         * Group multiple features into a feature group
         *
         * @param groupName name of the consent group
         * @param features  array of feature to be added to the consent group
         * @return Returns link to CoreProxy for call chaining
         */
        public void createFeatureGroup(String groupName, String[] features) {
            synchronized (_int) {
                _int.createFeatureGroup(groupName, features);
            }
        }
    }
}
