package sdk.main.core

import com.gojek.courier.QoS
import com.gojek.courier.annotation.Path
import com.gojek.courier.annotation.Subscribe
import com.gojek.courier.annotation.Unsubscribe
import com.gojek.mqtt.client.model.MqttMessage
import io.reactivex.Observable
import sdk.main.core.inappmessaging.model.message.IAMMessage

interface MqttCourierService {
    @Subscribe(topic = "{topic}", qos = QoS.TWO)
    fun subscribe(@Path("topic") topic: String): Observable<IAMMessage>

    @Subscribe(topic = "{topic}", qos = QoS.TWO)
    fun generalSubscribe(@Path("topic") topic: String): Observable<MqttMessage>

    @Unsubscribe(topics = ["{topic}"])
    fun unsubscribe(@Path("topic") topic: String)
}
