package sdk.main.core.ext

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.collectLatest
import kotlinx.coroutines.launch

internal open class HistoryStateFlow<T> private constructor(private val delegate: MutableStateFlow<T>) :
    MutableStateFlow<T> by delegate {

    open var oldValue: T? = null
    override var value: T
        get() = delegate.value
        set(newValue) {
            if (value != newValue) {
                oldValue = delegate.value
                delegate.value = newValue
            }
        }

    constructor(initialValue: T) : this(MutableStateFlow(initialValue))
}

internal fun <T> StateFlow<T>.withHistory(scope: CoroutineScope) =
    HistoryStateFlow(this.value).also { hist ->
        scope.launch {
            collectLatest {
                hist.value = it
            }
        }
    }
